/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.htmlunit.corejs.javascript.JavaAdapter;
import org.htmlunit.corejs.javascript.JavaMembers;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;

public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -8866246036237312215L;
    private static final Object AKEY = "ClassCache";
    private volatile boolean cachingIsEnabled = true;
    private volatile transient Map<CacheKey, JavaMembers> classTable;
    private volatile transient Map<JavaAdapter.JavaAdapterSignature, Class<?>> classAdapterCache;
    private volatile transient Map<Class<?>, Object> interfaceAdapterCache;
    private int generatedClassSerial;
    private Scriptable associatedScope;

    public static ClassCache get(Scriptable scope) {
        ClassCache cache = (ClassCache)ScriptableObject.getTopScopeValue(scope, AKEY);
        if (cache == null) {
            Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
            if (!(topScope instanceof ScriptableObject)) {
                throw new IllegalArgumentException("top scope have no associated ClassCache and cannot have ClassCache associated due to not being a ScriptableObject");
            }
            cache = new ClassCache();
            cache.associate((ScriptableObject)topScope);
        }
        return cache;
    }

    public boolean associate(ScriptableObject topScope) {
        if (topScope.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        if (this == topScope.associateValue(AKEY, this)) {
            this.associatedScope = topScope;
            return true;
        }
        return false;
    }

    public synchronized void clearCaches() {
        this.classTable = null;
        this.classAdapterCache = null;
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean enabled) {
        if (enabled == this.cachingIsEnabled) {
            return;
        }
        if (!enabled) {
            this.clearCaches();
        }
        this.cachingIsEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CacheKey, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            ClassCache classCache = this;
            synchronized (classCache) {
                if (this.classTable == null) {
                    this.classTable = new ConcurrentHashMap<CacheKey, JavaMembers>();
                }
            }
        }
        return this.classTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<JavaAdapter.JavaAdapterSignature, Class<?>> getInterfaceAdapterCacheMap() {
        if (this.classAdapterCache == null) {
            ClassCache classCache = this;
            synchronized (classCache) {
                if (this.classAdapterCache == null) {
                    this.classAdapterCache = new ConcurrentHashMap();
                }
            }
        }
        return this.classAdapterCache;
    }

    @Deprecated
    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    @Deprecated
    public synchronized void setInvokerOptimizationEnabled(boolean enabled) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class<?> cl) {
        return this.interfaceAdapterCache == null ? null : this.interfaceAdapterCache.get(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cacheInterfaceAdapter(Class<?> cl, Object iadapter) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                ClassCache classCache = this;
                synchronized (classCache) {
                    if (this.interfaceAdapterCache == null) {
                        this.interfaceAdapterCache = new ConcurrentHashMap();
                    }
                }
            }
            this.interfaceAdapterCache.put(cl, iadapter);
        }
    }

    Scriptable getAssociatedScope() {
        return this.associatedScope;
    }

    static class CacheKey {
        final Class<?> cls;
        final Object sec;

        public CacheKey(Class<?> cls, Object securityContext) {
            this.cls = cls;
            this.sec = securityContext;
        }

        public int hashCode() {
            if (this.sec != null) {
                return this.sec.hashCode() ^ this.cls.hashCode();
            }
            return this.cls.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CacheKey && Objects.equals(this.cls, ((CacheKey)obj).cls) && Objects.equals(this.sec, ((CacheKey)obj).sec);
        }
    }
}

