/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.htmlunit.csp.Utils;

public final class Hash {
    private final Algorithm algorithm_;
    private final String base64ValuePart_;

    private Hash(Algorithm algorithm, String base64ValuePart) {
        this.algorithm_ = algorithm;
        this.base64ValuePart_ = base64ValuePart;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm_;
    }

    public String getBase64ValuePart() {
        return this.base64ValuePart_;
    }

    public static Optional<Hash> parseHash(String value) {
        String lowcaseValue = value.toLowerCase(Locale.ROOT);
        if (lowcaseValue.startsWith("'sha") && lowcaseValue.endsWith("'")) {
            Algorithm algorithm;
            switch (lowcaseValue.substring(4, 7)) {
                case "256": {
                    algorithm = Algorithm.SHA256;
                    break;
                }
                case "384": {
                    algorithm = Algorithm.SHA384;
                    break;
                }
                case "512": {
                    algorithm = Algorithm.SHA512;
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            String hash = value.substring(8, value.length() - 1);
            if (Utils.IS_BASE64_VALUE.test(hash)) {
                return Optional.of(new Hash(algorithm, hash));
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return "'" + this.algorithm_.toString() + "-" + this.base64ValuePart_ + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash hash = (Hash)o;
        return this.algorithm_ == hash.algorithm_ && this.base64ValuePart_.equals(hash.base64ValuePart_);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm_, this.base64ValuePart_});
    }

    public static enum Algorithm {
        SHA256("sha256", 44),
        SHA384("sha384", 64),
        SHA512("sha512", 88);

        private final String value_;
        private final int length_;

        private Algorithm(String value, int length) {
            this.value_ = value;
            this.length_ = length;
        }

        public int getLength() {
            return this.length_;
        }

        public String toString() {
            return this.value_;
        }
    }
}

