/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNamespaceNode;
import org.htmlunit.html.HtmlPage;
import org.w3c.dom.Attr;
import org.w3c.dom.TypeInfo;

public class DomAttr
extends DomNamespaceNode
implements Attr {
    private String value_;
    private boolean specified_;

    public DomAttr(SgmlPage page, String namespaceURI, String qualifiedName, String value, boolean specified) {
        super(namespaceURI, qualifiedName, page);
        this.value_ = value != null && value.isEmpty() ? DomElement.ATTRIBUTE_VALUE_EMPTY : value;
        this.specified_ = specified;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getQualifiedName();
    }

    @Override
    public String getValue() {
        return this.value_;
    }

    @Override
    public void setNodeValue(String value) {
        this.setValue(value);
    }

    @Override
    public void setValue(String value) {
        this.value_ = value != null && value.isEmpty() ? DomElement.ATTRIBUTE_VALUE_EMPTY : value;
        this.specified_ = true;
    }

    @Override
    public DomElement getOwnerElement() {
        return (DomElement)this.getParentNode();
    }

    @Override
    public boolean getSpecified() {
        return this.specified_;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DomAttr.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public boolean isId() {
        return "id".equals(this.getNodeName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getNodeName() + " value=" + this.getNodeValue() + "]";
    }

    @Override
    public String getCanonicalXPath() {
        return this.getParentNode().getCanonicalXPath() + "/@" + this.getName();
    }

    @Override
    public String getTextContent() {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) {
        boolean mappedElement;
        boolean bl = mappedElement = this.getOwnerDocument() instanceof HtmlPage && ("name".equals(this.getName()) || "id".equals(this.getName()));
        if (mappedElement) {
            ((HtmlPage)this.getPage()).removeMappedElement(this.getOwnerElement(), false, false);
        }
        this.setValue(textContent);
        if (mappedElement) {
            ((HtmlPage)this.getPage()).addMappedElement(this.getOwnerElement(), false);
        }
    }
}

