/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.html.impl.Color;

public class HtmlColorInput
extends HtmlInput
implements LabelableElement {
    HtmlColorInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if (this.getValueAttribute() == ATTRIBUTE_NOT_DEFINED) {
            this.setValue("#000000");
        }
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            super.setValue("#000000");
            return;
        }
        if (HtmlColorInput.isValid(newValue)) {
            super.setValue(newValue);
        }
    }

    @Override
    protected void valueAttributeChanged(String attributeValue, boolean isValueDirty) {
        if (isValueDirty) {
            return;
        }
        if (StringUtils.isEmpty(attributeValue)) {
            this.setRawValue("#000000");
            return;
        }
        if (HtmlColorInput.isValid(attributeValue)) {
            this.setRawValue(attributeValue);
        }
    }

    private static boolean isValid(String value) {
        boolean valid = false;
        if (value.length() == 7 && value.charAt(0) == '#') {
            try {
                new Color(Integer.valueOf(value.substring(1, 3), 16), Integer.valueOf(value.substring(3, 5), 16), Integer.valueOf(value.substring(5, 7), 16));
                valid = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

