/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.KeyDataPair;
import org.htmlunit.util.NameValuePair;

public class HtmlFileInput
extends HtmlInput
implements LabelableElement {
    private String contentType_;
    private byte[] data_;
    private File[] files_ = new File[0];

    HtmlFileInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        DomAttr valueAttrib = attributes.get("value");
        if (valueAttrib != null) {
            this.setDefaultValue(valueAttrib.getNodeValue());
        }
    }

    public final byte[] getData() {
        return this.data_;
    }

    public final void setData(byte[] data) {
        this.data_ = data;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        if (this.files_ == null || this.files_.length == 0) {
            return new NameValuePair[]{new KeyDataPair(this.getNameAttribute(), null, null, null, (Charset)null)};
        }
        ArrayList<KeyDataPair> list = new ArrayList<KeyDataPair>();
        for (File file : this.files_) {
            String contentType;
            if (this.contentType_ == null) {
                contentType = this.getPage().getWebClient().getBrowserVersion().getUploadMimeType(file);
                if (StringUtils.isEmpty(contentType)) {
                    contentType = "application/octet-stream";
                }
            } else {
                contentType = this.contentType_;
            }
            Charset charset = this.getPage().getCharset();
            KeyDataPair keyDataPair = new KeyDataPair(this.getNameAttribute(), file, null, contentType, charset);
            keyDataPair.setData(this.data_);
            list.add(keyDataPair);
        }
        return list.toArray(new NameValuePair[0]);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }

    @Override
    public String getValue() {
        File[] files = this.getFiles();
        if (files == null || files.length == 0) {
            return ATTRIBUTE_NOT_DEFINED;
        }
        File first = files[0];
        String name = first.getName();
        if (name.isEmpty()) {
            return name;
        }
        return "C:\\fakepath\\" + name;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        String oldDefaultValue = this.getDefaultValue();
        super.setValueAttribute(defaultValue);
        if (oldDefaultValue.equals(this.getValue())) {
            this.setRawValue(defaultValue);
        }
    }

    @Override
    public void setValue(String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            this.setFiles(new File[0]);
            return;
        }
        File file = new File(newValue);
        if (file.isDirectory()) {
            this.setDirectory(file);
            return;
        }
        this.setFiles(file);
    }

    public void setFiles(File ... files) {
        if (files.length > 1 && ATTRIBUTE_NOT_DEFINED == this.getAttributeDirect("multiple")) {
            throw new IllegalStateException("HtmlFileInput - 'multiple' is not set.");
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = HtmlFileInput.normalizeFile(files[i]);
        }
        this.files_ = files;
        this.fireEvent("change");
    }

    public void setDirectory(File directory) {
        if (directory == null) {
            return;
        }
        if (ATTRIBUTE_NOT_DEFINED == this.getAttributeDirect("webkitdirectory")) {
            throw new IllegalStateException("HtmlFileInput - 'webkitdirectory' is not set.");
        }
        if (ATTRIBUTE_NOT_DEFINED == this.getAttributeDirect("multiple")) {
            throw new IllegalStateException("HtmlFileInput - 'multiple' is not set.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("HtmlFileInput - the provided directory '" + directory.getAbsolutePath() + "' is not a directory.");
        }
        Collection fileColl = FileUtils.listFiles((File)directory, null, (boolean)true);
        File[] files = new File[fileColl.size()];
        int i = 0;
        for (File file : fileColl) {
            files[i++] = HtmlFileInput.normalizeFile(file);
        }
        this.files_ = files;
        this.fireEvent("change");
    }

    private static File normalizeFile(File file) {
        File f = null;
        String path = file.getPath().replace('\\', '/');
        if (path.startsWith("file:/")) {
            if (path.startsWith("file://") && !path.startsWith("file:///")) {
                path = "file:///" + path.substring(7);
            }
            try {
                f = new File(new URI(path));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (f == null) {
            f = new File(path);
        }
        return f;
    }

    public File[] getFiles() {
        return this.files_;
    }

    @Override
    public boolean isValid() {
        return this.isCustomValidityValid() && (!this.isRequiredSupported() || ATTRIBUTE_NOT_DEFINED == this.getAttributeDirect("required") || this.files_.length > 0);
    }

    @Override
    protected void adjustValueAfterTypeChange(HtmlInput oldInput, BrowserVersion browserVersion) {
        this.setValue("");
    }
}

