/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Map;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.javascript.host.event.Event;

public class HtmlLabel
extends HtmlElement {
    public static final String TAG_NAME = "label";

    HtmlLabel(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getForAttribute() {
        return this.getAttributeDirect("for");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    @Override
    public void focus() {
        HtmlElement element = this.getLabeledElement();
        if (element != null) {
            element.focus();
        }
    }

    public HtmlElement getLabeledElement() {
        String elementId = this.getForAttribute();
        if (ATTRIBUTE_NOT_DEFINED == elementId) {
            for (DomNode element : this.getChildren()) {
                if (!(element instanceof LabelableElement)) continue;
                return (HtmlElement)element;
            }
        } else {
            try {
                Object element = ((HtmlPage)this.getPage()).getHtmlElementById(elementId);
                if (element instanceof LabelableElement) {
                    return element;
                }
            }
            catch (ElementNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public <P extends Page> P click(Event event, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean ignoreVisibility) throws IOException {
        Object page = super.click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
        HtmlElement element = this.getLabeledElement();
        if (element == null || element.isDisabledElementAndDisabled()) {
            return page;
        }
        return element.click(false, false, false, false, true, true, true);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

