/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.HTMLLinkElement;
import org.htmlunit.util.ArrayUtils;
import org.htmlunit.util.StringUtils;
import org.htmlunit.xml.XmlPage;

public class HtmlLink
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlLink.class);
    public static final String TAG_NAME = "link";
    private CssStyleSheet sheet_;

    HtmlLink(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttributeDirect("charset");
    }

    public final String getHrefAttribute() {
        return this.getAttributeDirect("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttributeDirect("hreflang");
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final String getRelAttribute() {
        return this.getAttributeDirect("rel");
    }

    public final String getRevAttribute() {
        return this.getAttributeDirect("rev");
    }

    public final String getMediaAttribute() {
        return this.getAttributeDirect("media");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        return this.getWebResponse(downloadIfNeeded, null, false, null);
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded, WebRequest request, boolean isStylesheetRequest, String type) throws IOException {
        WebClient webclient = this.getPage().getWebClient();
        if (null == request) {
            request = this.getWebRequest();
        }
        if (downloadIfNeeded) {
            try {
                WebResponse response = webclient.loadWebResponse(request);
                if (response.isSuccess()) {
                    if (isStylesheetRequest && webclient.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLLINK_CHECK_RESPONSE_TYPE_FOR_STYLESHEET)) {
                        if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(type) && !"text/css".equals(type)) {
                            return null;
                        }
                        String respType = response.getContentType();
                        if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(respType) && !"text/css".equals(respType)) {
                            this.executeEvent("error");
                            return response;
                        }
                    }
                    this.executeEvent("load");
                    return response;
                }
                this.executeEvent("error");
                return response;
            }
            catch (IOException e) {
                this.executeEvent("error");
                throw e;
            }
        }
        return webclient.getCache().getCachedResponse(request);
    }

    public WebRequest getWebRequest() throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getPage();
        URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
        BrowserVersion browser = page.getWebClient().getBrowserVersion();
        WebRequest request = new WebRequest(url, browser.getCssAcceptHeader(), browser.getAcceptEncodingHeader());
        request.setCharset(page.getCharset());
        request.setRefererHeader(page.getUrl());
        return request;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    private void executeEvent(String type) {
        HTMLLinkElement link = (HTMLLinkElement)this.getScriptableObject();
        Event event = new Event(this, type);
        link.executeEventLocally(event);
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        boolean isStyleSheetLink;
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Link node added: " + this.asXml()));
        }
        if (isStyleSheetLink = this.isStyleSheetLink()) {
            WebClient webClient = this.getPage().getWebClient();
            if (!webClient.getOptions().isCssEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stylesheet Link found but ignored because css support is disabled (" + this.asXml().replaceAll("[\\r\\n]", "") + ")."));
                }
                return;
            }
            if (!webClient.isJavaScriptEngineEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stylesheet Link found but ignored because javascript engine is disabled (" + this.asXml().replaceAll("[\\r\\n]", "") + ")."));
                }
                return;
            }
            PostponedAction action = new PostponedAction(this.getPage(), "Loading of link " + this){

                @Override
                public void execute() {
                    HTMLLinkElement linkElem = (HTMLLinkElement)HtmlLink.this.getScriptableObject();
                    linkElem.getSheet();
                }
            };
            AbstractJavaScriptEngine<?> engine = webClient.getJavaScriptEngine();
            if (postponed) {
                engine.addPostponedAction(action);
            } else {
                try {
                    action.execute();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Link type '" + this.getRelAttribute() + "' not supported (" + this.asXml().replaceAll("[\\r\\n]", "") + ")."));
        }
    }

    public CssStyleSheet getSheet() {
        if (this.sheet_ == null) {
            this.sheet_ = CssStyleSheet.loadStylesheet(this, this, null);
        }
        return this.sheet_;
    }

    public boolean isStyleSheetLink() {
        String rel = this.getRelAttribute();
        if (rel != null) {
            return ArrayUtils.containsIgnoreCase(StringUtils.splitAtBlank(rel), "stylesheet");
        }
        return false;
    }

    public boolean isModulePreloadLink() {
        String rel = this.getRelAttribute();
        if (rel != null) {
            return ArrayUtils.containsIgnoreCase(StringUtils.splitAtBlank(rel), "modulepreload");
        }
        return false;
    }

    public boolean isActiveStyleSheetLink() {
        if (this.isStyleSheetLink()) {
            String media = this.getMediaAttribute();
            if (hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(media)) {
                return true;
            }
            MediaListImpl mediaList = CssStyleSheet.parseMedia(media, this.getPage().getWebClient());
            return CssStyleSheet.isActive(mediaList, this.getPage().getEnclosingWindow());
        }
        return false;
    }
}

