/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.net.MalformedURLException;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.util.StringUtils;

public class HtmlMedia
extends HtmlElement {
    HtmlMedia(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public String canPlayType(String type) {
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isAllBlank(type)) {
            return "";
        }
        int semPos = type.indexOf(59);
        int codecPos = type.indexOf("codec");
        if (semPos > 0 && codecPos > semPos) {
            return "probably";
        }
        return "maybe";
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttribute();
        if (StringUtils.isEmptyString(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)this.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of media " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getCurrentSrc() {
        return "";
    }
}

