/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DoTypeProcessor;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.html.impl.SelectableTextSelectionDelegate;
import org.htmlunit.html.impl.SelectionDelegate;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.Node;

public class HtmlTextArea
extends HtmlElement
implements DisabledElement,
SubmittableElement,
LabelableElement,
SelectableTextInput,
FormFieldWithNameHistory,
ValidatableElement {
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;
    private String valueAtFocus_;
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private String customValidity_;
    private SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlTextArea(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = this.readValue();
        }
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent) {
            return true;
        }
        return super.handles(event);
    }

    @Override
    public final String getText() {
        return this.readValue();
    }

    private String readValue() {
        StringBuilder builder = new StringBuilder();
        for (DomNode node : this.getChildren()) {
            if (!(node instanceof DomText)) continue;
            builder.append(((DomText)node).getData());
        }
        if (builder.length() != 0 && builder.charAt(0) == '\n') {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    @Override
    public final void setText(String newValue) {
        this.setTextInternal(newValue);
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    private void setTextInternal(String newValue) {
        this.initDefaultValue();
        DomNode child = this.getFirstChild();
        if (child == null) {
            DomText newChild = new DomText((SgmlPage)this.getPage(), newValue);
            this.appendChild(newChild);
        } else {
            DomNode next = child.getNextSibling();
            while (next != null && !(next instanceof DomText)) {
                child = next;
                next = child.getNextSibling();
            }
            if (next == null) {
                this.removeChild(child);
                DomText newChild = new DomText((SgmlPage)this.getPage(), newValue);
                this.appendChild(newChild);
            } else {
                ((DomText)next).setData(newValue);
            }
        }
        int pos = newValue.length();
        this.setSelectionStart(pos);
        this.setSelectionEnd(pos);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String text = this.getText();
        text = text.replace("\r\n", "\n").replace("\n", "\r\n");
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), text)};
    }

    @Override
    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (this.getText().equals(this.getDefaultValue())) {
            this.setTextInternal(defaultValue);
        }
        this.defaultValue_ = defaultValue;
    }

    @Override
    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getRowsAttribute() {
        return this.getAttributeDirect("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttributeDirect("cols");
    }

    @Override
    public final boolean isDisabled() {
        if (this.hasAttribute("disabled")) {
            return true;
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof DisabledElement) || !((DisabledElement)((Object)node)).isDisabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeDirect("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeDirect("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeDirect("onchange");
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(StringUtils.escapeXml(this.getText()));
        printWriter.print("</textarea>");
    }

    @Override
    protected void doType(char c, boolean lastType) {
        this.doTypeProcessor_.doType(this.getText(), (SelectionDelegate)this.selectionDelegate_, c, (HtmlElement)this, lastType);
    }

    @Override
    protected void doType(int keyCode, boolean lastType) {
        this.doTypeProcessor_.doType(this.getText(), (SelectionDelegate)this.selectionDelegate_, keyCode, (HtmlElement)this, lastType);
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        this.setTextInternal(newValue);
    }

    @Override
    protected boolean acceptChar(char c) {
        return super.acceptChar(c) || c == '\n' || c == '\r';
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.getText();
    }

    @Override
    public void removeFocus() {
        super.removeFocus();
        if (this.valueAtFocus_ != null && !this.valueAtFocus_.equals(this.getText())) {
            HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = null;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCase(qualifiedName);
        if ("name".equals(qualifiedNameLC)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    public String getPlaceholder() {
        return this.getAttributeDirect("placeholder");
    }

    public void setPlaceholder(String placeholder) {
        this.setAttribute("placeholder", placeholder);
    }

    @Override
    protected boolean isRequiredSupported() {
        return true;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlTextArea newnode = (HtmlTextArea)super.cloneNode(deep);
        newnode.selectionDelegate_ = new SelectableTextSelectionDelegate(newnode);
        newnode.doTypeProcessor_ = new DoTypeProcessor(newnode);
        newnode.newNames_ = new HashSet<String>(this.newNames_);
        return newnode;
    }

    @Override
    public boolean willValidate() {
        return !this.isDisabled() && !this.isReadOnly();
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean isValid() {
        return this.isValidValidityState();
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(this.customValidity_);
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState() && !this.isValueMissingValidityState();
    }

    @Override
    public boolean isValueMissingValidityState() {
        return ATTRIBUTE_NOT_DEFINED != this.getAttributeDirect("required") && this.getText().isEmpty();
    }
}

