/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.htmlunit.WebWindow;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;

@JsxClass
public class History
extends HtmlUnitScriptable {
    private static final String SCROLL_RESTAURATION_AUTO = "auto";
    private static final String SCROLL_RESTAURATION_MANUAL = "manual";
    private String scrollRestoration_ = "auto";

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxGetter
    public int getLength() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getLength();
    }

    @JsxGetter
    public Object getState() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getCurrentState();
    }

    @JsxFunction
    public void back() {
        try {
            this.getWindow().getWebWindow().getHistory().back();
        }
        catch (IOException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void forward() {
        try {
            this.getWindow().getWebWindow().getHistory().forward();
        }
        catch (IOException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void go(int relativeIndex) {
        try {
            this.getWindow().getWebWindow().getHistory().go(relativeIndex);
        }
        catch (IOException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void replaceState(Object object, String title, Object url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().replaceState(object, History.buildNewStateUrl(w, url));
        }
        catch (MalformedURLException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void pushState(Object object, String title, Object url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().pushState(object, History.buildNewStateUrl(w, url));
        }
        catch (IOException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    private static URL buildNewStateUrl(WebWindow webWindow, Object url) throws MalformedURLException {
        String urlString;
        URL newStateUrl = null;
        if (url != null && !JavaScriptEngine.isUndefined(url) && StringUtils.isNotBlank(urlString = JavaScriptEngine.toString(url))) {
            HtmlPage page = (HtmlPage)webWindow.getEnclosedPage();
            newStateUrl = page.getFullyQualifiedUrl(urlString);
        }
        return newStateUrl;
    }

    @JsxGetter
    public String getScrollRestoration() {
        return this.scrollRestoration_;
    }

    @JsxSetter
    public void setScrollRestoration(String scrollRestoration) {
        if (SCROLL_RESTAURATION_AUTO.equals(scrollRestoration)) {
            this.scrollRestoration_ = SCROLL_RESTAURATION_AUTO;
            return;
        }
        if (SCROLL_RESTAURATION_MANUAL.equals(scrollRestoration)) {
            this.scrollRestoration_ = SCROLL_RESTAURATION_MANUAL;
        }
    }
}

