/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.AbstractList;

@JsxClass
public class HTMLCollection
extends AbstractList {
    public HTMLCollection() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public HTMLCollection(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive, null);
    }

    HTMLCollection(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    private HTMLCollection(DomNode domNode, boolean attributeChangeSensitive, List<DomNode> initialElements) {
        super(domNode, attributeChangeSensitive, new ArrayList<DomNode>(initialElements));
    }

    public static HTMLCollection emptyCollection(DomNode domNode) {
        return new HTMLCollection(domNode, false, Collections.emptyList());
    }

    @Override
    protected HTMLCollection create(DomNode parentScope, List<DomNode> initialElements) {
        return new HTMLCollection(parentScope, initialElements);
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @Override
    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @JsxFunction
    public Object item(Object index) {
        Object object;
        int idx = 0;
        double doubleValue = JavaScriptEngine.toNumber(index);
        if (!Double.isNaN(doubleValue)) {
            idx = (int)doubleValue;
        }
        if ((object = this.get(idx, (Scriptable)this)) == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public Scriptable namedItem(String name) {
        DomElement elem;
        List<DomNode> elements = this.getElements();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NAMED_ITEM_ID_FIRST)) {
            for (DomNode next : elements) {
                String id;
                if (!(next instanceof DomElement) || !name.equals(id = (elem = (DomElement)next).getId())) continue;
                return this.getScriptableForElement(elem);
            }
        }
        for (DomNode next : elements) {
            if (!(next instanceof DomElement)) continue;
            elem = (DomElement)next;
            String nodeName = elem.getAttributeDirect("name");
            if (name.equals(nodeName)) {
                return this.getScriptableForElement(elem);
            }
            String id = elem.getId();
            if (!name.equals(id)) continue;
            return this.getScriptableForElement(elem);
        }
        return null;
    }
}

