/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.intl;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.Window;

@JsxClass
public class DateTimeFormat
extends HtmlUnitScriptable {
    private static final ConcurrentHashMap<String, String> CHROME_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> EDGE_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_ESR_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Chronology> CHROME_CHRONOLOGIES_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Chronology> EDGE_CHRONOLOGIES_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Chronology> FF_CHRONOLOGIES_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Chronology> FF_ESR_CHRONOLOGIES_ = new ConcurrentHashMap();
    private transient DateTimeFormatHelper formatter_;

    public DateTimeFormat() {
    }

    private DateTimeFormat(String[] locales, BrowserVersion browserVersion) {
        ConcurrentHashMap<String, Chronology> chronologies;
        ConcurrentHashMap<String, String> formats;
        if (browserVersion.isChrome()) {
            formats = CHROME_FORMATS_;
            chronologies = CHROME_CHRONOLOGIES_;
        } else if (browserVersion.isEdge()) {
            formats = EDGE_FORMATS_;
            chronologies = EDGE_CHRONOLOGIES_;
        } else if (browserVersion.isFirefoxESR()) {
            formats = FF_ESR_FORMATS_;
            chronologies = FF_ESR_CHRONOLOGIES_;
        } else {
            formats = FF_FORMATS_;
            chronologies = FF_CHRONOLOGIES_;
        }
        String locale = browserVersion.getBrowserLocale().toLanguageTag();
        String pattern = DateTimeFormat.getPattern(formats, locale);
        for (String l : locales) {
            pattern = DateTimeFormat.getPattern(formats, l);
            if (pattern == null) continue;
            locale = l;
        }
        if (pattern == null) {
            pattern = (String)formats.get("");
        }
        if (!locale.startsWith("ar")) {
            pattern = pattern.replace("\u200e", "");
        }
        Chronology chronology = DateTimeFormat.getChronology(chronologies, locale);
        this.formatter_ = new DateTimeFormatHelper(locale, chronology, pattern);
    }

    private static String getPattern(Map<String, String> formats, String locale) {
        if ("no-NO-NY".equals(locale)) {
            throw JavaScriptEngine.rangeError("Invalid language tag: " + locale);
        }
        String pattern = formats.get(locale);
        while (pattern == null && locale.indexOf(45) != -1) {
            locale = locale.substring(0, locale.lastIndexOf(45));
            pattern = formats.get(locale);
        }
        return pattern;
    }

    private static Chronology getChronology(Map<String, Chronology> chronologies, String locale) {
        Chronology chronology = chronologies.get(locale);
        while (chronology == null && locale.indexOf(45) != -1) {
            locale = locale.substring(0, locale.lastIndexOf(45));
            chronology = chronologies.get(locale);
        }
        return chronology;
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        String[] locales;
        if (args.length != 0) {
            if (args[0] instanceof NativeArray) {
                NativeArray array = (NativeArray)args[0];
                locales = new String[(int)array.getLength()];
                for (int i = 0; i < locales.length; ++i) {
                    locales[i] = JavaScriptEngine.toString(array.get(i));
                }
            } else {
                locales = new String[]{JavaScriptEngine.toString(args[0])};
            }
        } else {
            locales = new String[]{};
        }
        Window window = DateTimeFormat.getWindow(ctorObj);
        DateTimeFormat format = new DateTimeFormat(locales, window.getBrowserVersion());
        format.setParentScope(window);
        format.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        return format;
    }

    @JsxFunction
    public String format(Object object) {
        Date date = (Date)Context.jsToJava(object, Date.class);
        return this.formatter_.format(date, Context.getCurrentContext().getTimeZone().toZoneId());
    }

    @JsxFunction
    public Scriptable resolvedOptions() {
        Context cx = Context.getCurrentContext();
        Scriptable options = cx.newObject(this.getParentScope());
        options.put("timeZone", options, (Object)cx.getTimeZone().getID());
        if (StringUtils.isEmpty(this.formatter_.locale_)) {
            options.put("locale", options, (Object)cx.getLocale().toLanguageTag());
        } else {
            options.put("locale", options, (Object)this.formatter_.locale_);
        }
        return options;
    }

    static {
        String ddSlash = "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY";
        String ddDash = "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY";
        String ddDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY";
        String ddDotDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.";
        String ddDotBlank = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY";
        String ddDotBlankDot = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.";
        String mmSlash = "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY";
        String yyyySlash = "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd";
        String yyyyDash = "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd";
        String yyyyDotBlankDot = "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.";
        HashMap<String, String> commonFormats = new HashMap<String, String>();
        commonFormats.put("", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ar", "dd\u200f/MM\u200f/YYYY");
        commonFormats.put("ban", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("be", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("bg", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e \u0433.");
        commonFormats.put("ca", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("cs", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("da", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("de", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("el", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("en-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("en-NZ", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-PA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-PH", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("en-AU", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-GB", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-IE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-IN", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-MT", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-SG", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-ZA", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("es", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("es-CL", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        commonFormats.put("es-PA", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("es-PR", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("es-US", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("et", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("fi", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("fr", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("fr-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("ga", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("hi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("hr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        commonFormats.put("hu", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        commonFormats.put("id", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("in", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("is", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("it", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("iw", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ja", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("ja-JP-u-ca-japanese", "'H'yy/MM/dd");
        commonFormats.put("ko", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        commonFormats.put("lt", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("lv", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        commonFormats.put("mk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ms", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("mt", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("nl", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        commonFormats.put("nl-BE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("pl", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("pt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("ro", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ru", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("sl", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("sq", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("sr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        commonFormats.put("sv", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("th", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("tr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("uk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("vi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("zh", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("zh-HK", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("zh-SG", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        commonFormats.put("fr-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_FORMATS_.putAll(commonFormats);
        FF_FORMATS_.put("mk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e \u0433.");
        commonFormats.put("ar-SA", "d\u200f/M\u200f/YYYY \u0647\u0640");
        FF_ESR_FORMATS_.putAll(commonFormats);
        commonFormats.put("be", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("ga", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("is", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("mk", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        EDGE_FORMATS_.putAll(commonFormats);
        CHROME_FORMATS_.putAll(commonFormats);
        CHROME_FORMATS_.put("sq", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        HashMap<String, AbstractChronology> commonChronologies = new HashMap<String, AbstractChronology>();
        commonChronologies.put("ja-JP-u-ca-japanese", JapaneseChronology.INSTANCE);
        commonChronologies.put("th", ThaiBuddhistChronology.INSTANCE);
        commonChronologies.put("th-TH", ThaiBuddhistChronology.INSTANCE);
        FF_CHRONOLOGIES_.putAll(commonChronologies);
        commonChronologies.put("ar-SA", HijrahChronology.INSTANCE);
        CHROME_CHRONOLOGIES_.putAll(commonChronologies);
        EDGE_CHRONOLOGIES_.putAll(commonChronologies);
        FF_ESR_CHRONOLOGIES_.putAll(commonChronologies);
    }

    static final class DateTimeFormatHelper {
        private final DateTimeFormatter formatter_;
        private Chronology chronology_;
        private final String locale_;

        DateTimeFormatHelper(String locale, Chronology chronology, String pattern) {
            this.locale_ = locale;
            this.chronology_ = chronology;
            if (!(!locale.startsWith("ar") || "ar-DZ".equals(locale) || "ar-LY".equals(locale) || "ar-MA".equals(locale) || "ar-TN".equals(locale))) {
                DecimalStyle decimalStyle = DecimalStyle.STANDARD.withZeroDigit('\u0660');
                this.formatter_ = DateTimeFormatter.ofPattern(pattern).withDecimalStyle(decimalStyle);
            } else {
                this.formatter_ = DateTimeFormatter.ofPattern(pattern);
            }
        }

        String format(Date date, ZoneId zoneId) {
            Comparable<ChronoZonedDateTime<?>> zonedDateTime = date.toInstant().atZone(zoneId);
            if (this.chronology_ != null) {
                zonedDateTime = this.chronology_.date((TemporalAccessor)((Object)zonedDateTime));
            }
            return this.formatter_.format((TemporalAccessor)((Object)zonedDateTime));
        }
    }
}

