/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.util.Locale;
import org.htmlunit.cyberneko.util.FastHashMap;
import org.htmlunit.util.StringUtils;

public final class MimeType {
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    private static final FastHashMap<String, String> TYPE2EXTENSION = MimeType.buildMap();
    private static final FastHashMap<String, Boolean> LOOKUP_MAP = new FastHashMap(33, 0.7f);

    public static boolean isJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String mimeTypeLC = StringUtils.toRootLowerCase(mimeType);
        return TEXT_JAVASCRIPT.equals(mimeTypeLC) || "application/javascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    public static boolean isObsoleteJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (LOOKUP_MAP.get(mimeType) != null) {
            return true;
        }
        String mimeTypeLC = mimeType.toLowerCase(Locale.ROOT);
        return "application/javascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    private static FastHashMap<String, String> buildMap() {
        FastHashMap<String, String> map = new FastHashMap<String, String>(23, 0.7f);
        map.put("application/pdf", "pdf");
        map.put("application/x-javascript", "js");
        map.put(IMAGE_GIF, "gif");
        map.put("image/jpg", "jpeg");
        map.put(IMAGE_JPEG, "jpeg");
        map.put(IMAGE_PNG, "png");
        map.put("image/svg+xml", "svg");
        map.put(TEXT_CSS, "css");
        map.put(TEXT_HTML, "html");
        map.put(TEXT_PLAIN, "txt");
        map.put("image/x-icon", "ico");
        for (String k : map.keys()) {
            map.put(k.toUpperCase(Locale.ROOT), map.get(k));
        }
        return map;
    }

    private MimeType() {
    }

    public static String getFileExtension(String contentType) {
        if (contentType == null) {
            return "unknown";
        }
        String value = TYPE2EXTENSION.get(contentType);
        if (value == null) {
            String uppercased = contentType.toLowerCase(Locale.ROOT);
            value = TYPE2EXTENSION.get(uppercased);
        }
        return value == null ? "unknown" : value;
    }

    static {
        LOOKUP_MAP.put("application/javascript", true);
        LOOKUP_MAP.put("application/x-ecmascript", true);
        LOOKUP_MAP.put("application/x-javascript", true);
        LOOKUP_MAP.put("text/ecmascript", true);
        LOOKUP_MAP.put("application/ecmascript", true);
        LOOKUP_MAP.put("text/javascript1.0", true);
        LOOKUP_MAP.put("text/javascript1.1", true);
        LOOKUP_MAP.put("text/javascript1.2", true);
        LOOKUP_MAP.put("text/javascript1.3", true);
        LOOKUP_MAP.put("text/javascript1.4", true);
        LOOKUP_MAP.put("text/javascript1.5", true);
        LOOKUP_MAP.put("text/jscript", true);
        LOOKUP_MAP.put("text/livescript", true);
        LOOKUP_MAP.put("text/x-ecmascript", true);
        LOOKUP_MAP.put("text/x-javascript", true);
        for (String k : LOOKUP_MAP.keys()) {
            LOOKUP_MAP.put(k.toUpperCase(Locale.ROOT), true);
        }
    }
}

