/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.http.entity.mime;

import hidden.jth.org.apache.http.ContentTooLongException;
import hidden.jth.org.apache.http.Header;
import hidden.jth.org.apache.http.HttpEntity;
import hidden.jth.org.apache.http.entity.ContentType;
import hidden.jth.org.apache.http.entity.mime.AbstractMultipartForm;
import hidden.jth.org.apache.http.message.BasicHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class MultipartFormEntity
implements HttpEntity {
    private final AbstractMultipartForm multipart;
    private final Header contentType;
    private final long contentLength;

    MultipartFormEntity(AbstractMultipartForm multipart, ContentType contentType, long contentLength) {
        this.multipart = multipart;
        this.contentType = new BasicHeader("Content-Type", contentType.toString());
        this.contentLength = contentLength;
    }

    AbstractMultipartForm getMultipart() {
        return this.multipart;
    }

    @Override
    public boolean isRepeatable() {
        return this.contentLength != -1L;
    }

    @Override
    public boolean isChunked() {
        return !this.isRepeatable();
    }

    @Override
    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Header getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return null;
    }

    @Override
    public void consumeContent() {
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.contentLength < 0L) {
            throw new ContentTooLongException("Content length is unknown");
        }
        if (this.contentLength > 25600L) {
            throw new ContentTooLongException("Content length is too long: " + this.contentLength);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.writeTo(outStream);
        outStream.flush();
        return new ByteArrayInputStream(outStream.toByteArray());
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        this.multipart.writeTo(outStream);
    }
}

