/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.net.URL;
import org.htmlunit.WebResponse;

public class FailingHttpStatusCodeException
extends RuntimeException {
    private final WebResponse response_;

    public FailingHttpStatusCodeException(WebResponse failingResponse) {
        this(FailingHttpStatusCodeException.buildMessage(failingResponse), failingResponse);
    }

    public FailingHttpStatusCodeException(String message, WebResponse failingResponse) {
        super(message);
        this.response_ = failingResponse;
    }

    public int getStatusCode() {
        return this.response_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.response_.getStatusMessage();
    }

    private static String buildMessage(WebResponse failingResponse) {
        int code = failingResponse.getStatusCode();
        String msg = failingResponse.getStatusMessage();
        URL url = failingResponse.getWebRequest().getUrl();
        return code + " " + msg + " for " + url;
    }

    public WebResponse getResponse() {
        return this.response_;
    }
}

