/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;

public class StorageHolder
implements Serializable {
    private final Map<String, Map<String, String>> localStorage_ = new HashMap<String, Map<String, String>>();
    private transient Map<String, Map<String, String>> sessionStorage_ = new HashMap<String, Map<String, String>>();

    public Map<String, String> getStore(Type storageType, Page page) {
        switch (storageType) {
            case LOCAL_STORAGE: {
                return this.getLocalStorage(page.getUrl());
            }
            case SESSION_STORAGE: {
                return this.getSessionStorage(page.getEnclosingWindow());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getLocalStorage(URL url) {
        Map<String, Map<String, String>> map = this.localStorage_;
        synchronized (map) {
            String key = url.getProtocol() + "://" + url.getHost();
            return this.localStorage_.computeIfAbsent(key, k -> new LinkedHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSessionStorage(WebWindow webWindow) {
        Map<String, Map<String, String>> map = this.sessionStorage_;
        synchronized (map) {
            WebWindow topWindow = webWindow.getTopWindow();
            String key = Integer.toHexString(topWindow.hashCode());
            return this.sessionStorage_.computeIfAbsent(key, k -> new LinkedHashMap());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.sessionStorage_ = new HashMap<String, Map<String, String>>();
    }

    public static enum Type {
        LOCAL_STORAGE,
        SESSION_STORAGE;

    }
}

