/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import hidden.jth.org.apache.http.auth.Credentials;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.htmlunit.FormEncodingType;
import org.htmlunit.HttpMethod;
import org.htmlunit.http.HttpUtils;
import org.htmlunit.httpclient.HtmlUnitUsernamePasswordCredentials;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.UrlUtils;

public class WebRequest
implements Serializable {
    private static final Pattern DOT_PATTERN = Pattern.compile("/\\./");
    private static final Pattern DOT_DOT_PATTERN = Pattern.compile("/(?!\\.\\.)[^/]*/\\.\\./");
    private static final Pattern REMOVE_DOTS_PATTERN = Pattern.compile("^/(\\.\\.?/)*");
    private String url_;
    private String proxyHost_;
    private int proxyPort_;
    private String proxyScheme_;
    private boolean isSocksProxy_;
    private HttpMethod httpMethod_ = HttpMethod.GET;
    private FormEncodingType encodingType_ = FormEncodingType.URL_ENCODED;
    private Map<String, String> additionalHeaders_ = new HashMap<String, String>();
    private Credentials urlCredentials_;
    private Credentials credentials_;
    private int timeout_;
    private transient Set<HttpHint> httpHints_;
    private transient Charset charset_ = StandardCharsets.ISO_8859_1;
    private transient Charset defaultResponseContentCharset_ = StandardCharsets.ISO_8859_1;
    private List<NameValuePair> requestParameters_ = Collections.emptyList();
    private String requestBody_;

    public WebRequest(URL url, String acceptHeader, String acceptEncodingHeader) {
        this.setUrl(url);
        if (acceptHeader != null) {
            this.setAdditionalHeader("Accept", acceptHeader);
        }
        if (acceptEncodingHeader != null) {
            this.setAdditionalHeader("Accept-Encoding", acceptEncodingHeader);
        }
        this.timeout_ = -1;
    }

    public WebRequest(URL url, Charset charset, URL refererUrl) {
        this.setUrl(url);
        this.setCharset(charset);
        this.setRefererHeader(refererUrl);
    }

    public static WebRequest newAboutBlankRequest() {
        return new WebRequest(UrlUtils.URL_ABOUT_BLANK, "*/*", "gzip, deflate");
    }

    public WebRequest(URL url) {
        this(url, "*/*", "gzip, deflate");
    }

    public WebRequest(URL url, HttpMethod submitMethod) {
        this(url);
        this.setHttpMethod(submitMethod);
    }

    public URL getUrl() {
        return UrlUtils.toUrlSafe(this.url_);
    }

    public void setUrl(URL url) {
        if (url == null) {
            this.url_ = null;
            return;
        }
        String path = url.getPath();
        if (path.isEmpty()) {
            if (!url.getFile().isEmpty() || url.getProtocol().startsWith("http")) {
                url = WebRequest.buildUrlWithNewPath(url, "/");
            }
        } else if (path.contains("/.")) {
            url = WebRequest.buildUrlWithNewPath(url, WebRequest.removeDots(path));
        }
        try {
            String idn = IDN.toASCII(url.getHost());
            if (!idn.equals(url.getHost())) {
                url = UrlUtils.getUrlWithNewHost(url, idn);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert the hostname of URL: '" + url.toExternalForm() + "' to ASCII.", e);
        }
        try {
            this.url_ = UrlUtils.removeRedundantPort(url).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot strip default port of URL: " + url.toExternalForm(), e);
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            int splitPos = userInfo.indexOf(58);
            if (splitPos == -1) {
                this.urlCredentials_ = new HtmlUnitUsernamePasswordCredentials(userInfo, new char[0]);
            } else {
                String username = userInfo.substring(0, splitPos);
                String password = userInfo.substring(splitPos + 1);
                this.urlCredentials_ = new HtmlUnitUsernamePasswordCredentials(username, password.toCharArray());
            }
        }
    }

    private static String removeDots(String path) {
        String newPath = path;
        if ("/..".equals(newPath = REMOVE_DOTS_PATTERN.matcher(newPath).replaceAll("/"))) {
            newPath = "/";
        }
        while (DOT_PATTERN.matcher(newPath).find()) {
            newPath = DOT_PATTERN.matcher(newPath).replaceAll("/");
        }
        while (DOT_DOT_PATTERN.matcher(newPath).find()) {
            newPath = DOT_DOT_PATTERN.matcher(newPath).replaceAll("/");
        }
        return newPath;
    }

    private static URL buildUrlWithNewPath(URL url, String newPath) {
        try {
            url = UrlUtils.getUrlWithNewPath(url, newPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot change path of URL: " + url.toExternalForm(), e);
        }
        return url;
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme_;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme_ = proxyScheme;
    }

    public boolean isSocksProxy() {
        return this.isSocksProxy_;
    }

    public void setSocksProxy(boolean isSocksProxy) {
        this.isSocksProxy_ = isSocksProxy;
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public FormEncodingType getEncodingType() {
        return this.encodingType_;
    }

    public void setEncodingType(FormEncodingType encodingType) {
        this.encodingType_ = encodingType;
    }

    public List<NameValuePair> getParameters() {
        ArrayList<NameValuePair> allParameters = new ArrayList<NameValuePair>(HttpUtils.parseUrlQuery(this.getUrl().getQuery(), this.getCharset()));
        HttpMethod httpMethod = this.getHttpMethod();
        if (httpMethod == HttpMethod.POST || httpMethod == HttpMethod.PUT || httpMethod == HttpMethod.PATCH || httpMethod == HttpMethod.DELETE || httpMethod == HttpMethod.OPTIONS) {
            if (FormEncodingType.URL_ENCODED == this.getEncodingType() && httpMethod != HttpMethod.OPTIONS) {
                if (this.getRequestBody() == null) {
                    allParameters.addAll(this.getRequestParameters());
                } else {
                    allParameters.addAll(HttpUtils.parseUrlQuery(this.getRequestBody(), this.getCharset()));
                }
            } else if (FormEncodingType.MULTIPART == this.getEncodingType()) {
                if (httpMethod == HttpMethod.POST) {
                    allParameters.addAll(this.getRequestParameters());
                } else {
                    allParameters.addAll(0, this.getRequestParameters());
                }
            }
        }
        return WebRequest.normalize(allParameters);
    }

    private static List<NameValuePair> normalize(List<NameValuePair> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return pairs;
        }
        ArrayList<NameValuePair> resultingPairs = new ArrayList<NameValuePair>();
        for (NameValuePair pair : pairs) {
            resultingPairs.add(pair.normalized());
        }
        return resultingPairs;
    }

    public List<NameValuePair> getRequestParameters() {
        return this.requestParameters_;
    }

    public void setRequestParameters(List<NameValuePair> requestParameters) throws RuntimeException {
        if (this.requestBody_ != null) {
            String msg = "Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!");
        }
        this.requestParameters_ = requestParameters;
    }

    public String getRequestBody() {
        return this.requestBody_;
    }

    public void setRequestBody(String requestBody) throws RuntimeException {
        if (this.requestParameters_ != null && !this.requestParameters_.isEmpty()) {
            String msg = "Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!");
        }
        if (this.httpMethod_ != HttpMethod.POST && this.httpMethod_ != HttpMethod.PUT && this.httpMethod_ != HttpMethod.PATCH && this.httpMethod_ != HttpMethod.DELETE && this.httpMethod_ != HttpMethod.OPTIONS) {
            String msg = "The request body may only be set for POST, PUT, PATCH, DELETE or OPTIONS requests!";
            throw new RuntimeException("The request body may only be set for POST, PUT, PATCH, DELETE or OPTIONS requests!");
        }
        this.requestBody_ = requestBody;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod_;
    }

    public void setHttpMethod(HttpMethod submitMethod) {
        this.httpMethod_ = submitMethod;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders_;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders_ = additionalHeaders;
    }

    public boolean isAdditionalHeader(String name) {
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String getAdditionalHeader(String name) {
        String newKey = name;
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            newKey = key;
            break;
        }
        return this.additionalHeaders_.get(newKey);
    }

    public void setRefererHeader(URL url) {
        if (url == null || !url.getProtocol().startsWith("http")) {
            return;
        }
        try {
            this.setAdditionalHeader("Referer", UrlUtils.getUrlWithoutRef(url).toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setAdditionalHeader(String name, String value) {
        String newKey = name;
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            newKey = key;
            break;
        }
        this.additionalHeaders_.put(newKey, value);
    }

    public void removeAdditionalHeader(String name) {
        for (String key : this.additionalHeaders_.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            name = key;
            break;
        }
        this.additionalHeaders_.remove(name);
    }

    public Credentials getUrlCredentials() {
        return this.urlCredentials_;
    }

    public Credentials getCredentials() {
        return this.credentials_;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials_ = credentials;
    }

    public Charset getCharset() {
        return this.charset_;
    }

    public void setCharset(Charset charset) {
        this.charset_ = charset;
    }

    public Charset getDefaultResponseContentCharset() {
        return this.defaultResponseContentCharset_;
    }

    public void setDefaultResponseContentCharset(Charset defaultResponseContentCharset) {
        this.defaultResponseContentCharset_ = Objects.requireNonNull(defaultResponseContentCharset);
    }

    public boolean hasHint(HttpHint hint) {
        if (this.httpHints_ == null) {
            return false;
        }
        return this.httpHints_.contains((Object)hint);
    }

    public void addHint(HttpHint hint) {
        if (this.httpHints_ == null) {
            this.httpHints_ = EnumSet.noneOf(HttpHint.class);
        }
        this.httpHints_.add(hint);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100).append(this.getClass().getSimpleName()).append("[<url=\"").append(this.url_).append("\", ").append((Object)this.httpMethod_).append(", ").append(this.encodingType_).append(", ").append(this.requestParameters_).append(", ").append(this.additionalHeaders_).append(", ").append(this.credentials_).append(">]");
        return builder.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.charset_ == null ? null : this.charset_.name());
        oos.writeObject(this.defaultResponseContentCharset_ == null ? null : this.defaultResponseContentCharset_.name());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        String defaultResponseContentCharset;
        ois.defaultReadObject();
        String charsetName = (String)ois.readObject();
        if (charsetName != null) {
            this.charset_ = Charset.forName(charsetName);
        }
        if ((defaultResponseContentCharset = (String)ois.readObject()) != null) {
            this.defaultResponseContentCharset_ = Charset.forName(defaultResponseContentCharset);
        }
    }

    public static enum HttpHint {
        IncludeCharsetInContentTypeHeader,
        BlockCookies;

    }
}

