/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import org.htmlunit.corejs.javascript.ast.Jump;
import org.htmlunit.corejs.javascript.ast.Loop;
import org.htmlunit.corejs.javascript.ast.Name;
import org.htmlunit.corejs.javascript.ast.NodeVisitor;

public class ContinueStatement
extends Jump {
    private Name label;
    private Loop targetLoop;

    public ContinueStatement() {
        this.type = 135;
    }

    public ContinueStatement(int pos) {
        this(pos, -1);
    }

    public ContinueStatement(int pos, int len) {
        this.type = 135;
        this.position = pos;
        this.length = len;
    }

    public ContinueStatement(Name label) {
        this.type = 135;
        this.setLabel(label);
    }

    public ContinueStatement(int pos, Name label) {
        this(pos);
        this.setLabel(label);
    }

    public ContinueStatement(int pos, int len, Name label) {
        this(pos, len);
        this.setLabel(label);
    }

    public Loop getTarget() {
        return this.targetLoop;
    }

    public void setTarget(Loop target) {
        this.assertNotNull(target);
        this.targetLoop = target;
        this.setJumpStatement(this.targetLoop);
    }

    public Name getLabel() {
        return this.label;
    }

    public void setLabel(Name label) {
        this.label = label;
        if (label != null) {
            label.setParent(this);
        }
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("continue");
        if (this.label != null) {
            sb.append(" ");
            sb.append(this.label.toSource(0));
        }
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this) && this.label != null) {
            this.label.visit(v);
        }
    }
}

