/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.htmlunit.corejs.javascript.ast.AbstractObjectProperty;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.DestructuringForm;
import org.htmlunit.corejs.javascript.ast.NodeVisitor;

public class ObjectLiteral
extends AstNode
implements DestructuringForm {
    private static final List<AbstractObjectProperty> NO_ELEMS = Collections.unmodifiableList(new ArrayList());
    private List<AbstractObjectProperty> elements;
    boolean isDestructuring;

    public ObjectLiteral() {
        this.type = 73;
    }

    public ObjectLiteral(int pos) {
        super(pos);
        this.type = 73;
    }

    public ObjectLiteral(int pos, int len) {
        super(pos, len);
        this.type = 73;
    }

    public List<AbstractObjectProperty> getElements() {
        return this.elements != null ? this.elements : NO_ELEMS;
    }

    public void setElements(List<AbstractObjectProperty> elements) {
        if (elements == null) {
            this.elements = null;
        } else {
            if (this.elements != null) {
                this.elements.clear();
            }
            for (AbstractObjectProperty o : elements) {
                this.addElement(o);
            }
        }
    }

    public void addElement(AbstractObjectProperty element) {
        this.assertNotNull(element);
        if (this.elements == null) {
            this.elements = new ArrayList<AbstractObjectProperty>();
        }
        this.elements.add(element);
        element.setParent(this);
    }

    @Override
    public void setIsDestructuring(boolean destructuring) {
        this.isDestructuring = destructuring;
    }

    @Override
    public boolean isDestructuring() {
        return this.isDestructuring;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("{");
        if (this.elements != null) {
            int i = 0;
            sb.append("\n");
            for (AbstractObjectProperty element : this.elements) {
                sb.append(element.toSource(depth));
                if (sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (i < this.elements.size() - 1) {
                    sb.append(",");
                }
                sb.append("\n");
                ++i;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            for (AbstractObjectProperty prop : this.getElements()) {
                prop.visit(v);
            }
        }
    }
}

