/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type.impl;

import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.ClassTypeInfo;

public class PrimitiveClassTypeInfo
extends ClassTypeInfo {
    private final Object defaultValue;

    public PrimitiveClassTypeInfo(Class<?> type, Object defaultValue) {
        super(type);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean is(Class<?> c) {
        return c.isPrimitive() && this.asClass() == c;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object createDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isVoid() {
        return this.asClass() == Void.TYPE;
    }

    @Override
    public boolean isBoolean() {
        return this.asClass() == Boolean.TYPE;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isByte() {
        return this.asClass() == Byte.TYPE;
    }

    @Override
    public boolean isShort() {
        return this.asClass() == Short.TYPE;
    }

    @Override
    public boolean isInt() {
        return this.asClass() == Integer.TYPE;
    }

    @Override
    public boolean isLong() {
        return this.asClass() == Long.TYPE;
    }

    @Override
    public boolean isFloat() {
        return this.asClass() == Float.TYPE;
    }

    @Override
    public boolean isDouble() {
        return this.asClass() == Double.TYPE;
    }

    @Override
    public boolean isCharacter() {
        return this.asClass() == Character.TYPE;
    }

    @Override
    public boolean isAssignableFrom(TypeInfo another) {
        return this == another;
    }
}

