/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.StringUtils;

public class HtmlDateTimeLocalInput
extends HtmlInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    HtmlDateTimeLocalInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        try {
            if (!StringUtils.isEmptyOrNull(newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValue(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (!this.getMin().isEmpty()) {
            try {
                LocalDateTime dateValue = LocalDateTime.parse(this.getRawValue(), FORMATTER_);
                LocalDateTime minDate = LocalDateTime.parse(this.getMin(), FORMATTER_);
                return minDate.isEqual(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (!this.getMax().isEmpty()) {
            try {
                LocalDateTime dateValue = LocalDateTime.parse(this.getRawValue(), FORMATTER_);
                LocalDateTime maxDate = LocalDateTime.parse(this.getMax(), FORMATTER_);
                return maxDate.isEqual(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected void adjustValueAfterTypeChange(HtmlInput oldInput, BrowserVersion browserVersion) {
        this.setValue("");
    }
}

