/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.PrintWriter;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.HtmlElement;

public class HtmlTemplate
extends HtmlElement {
    public static final String TAG_NAME = "template";
    private final DomDocumentFragment domDocumentFragment_;

    HtmlTemplate(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.domDocumentFragment_ = new DomDocumentFragment(page);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    public DomDocumentFragment getContent() {
        return this.domDocumentFragment_;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected boolean printXml(String indent, boolean tagBefore, PrintWriter printWriter) {
        boolean hasChildren;
        boolean bl = hasChildren = this.domDocumentFragment_.getFirstChild() != null;
        if (tagBefore) {
            printWriter.print("\r\n");
            printWriter.print(indent);
        }
        printWriter.print('<');
        this.printOpeningTagContentAsXml(printWriter);
        if (hasChildren) {
            printWriter.print(">");
            boolean tag = this.domDocumentFragment_.printChildrenAsXml(indent, tagBefore, printWriter);
            if (tag) {
                printWriter.print("\r\n");
                printWriter.print(indent);
            }
            printWriter.print("</");
            printWriter.print(this.getTagName());
            printWriter.print(">");
        } else if (this.isEmptyXmlTagExpanded()) {
            printWriter.print("></");
            printWriter.print(this.getTagName());
            printWriter.print(">");
        } else {
            printWriter.print("/>");
        }
        return true;
    }
}

