/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.impl;

import org.htmlunit.html.DomNode;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.html.impl.SelectionDelegate;
import org.htmlunit.html.impl.SimpleRange;

public class SelectableTextSelectionDelegate
implements SelectionDelegate {
    private final SelectableTextInput element_;
    private final SimpleRange selection_;

    public SelectableTextSelectionDelegate(SelectableTextInput element) {
        this.element_ = element;
        this.selection_ = new SimpleRange((DomNode)((Object)element), 0);
    }

    public void select() {
        this.element_.focus();
        this.setSelectionStart(0);
        this.setSelectionEnd(this.element_.getText().length());
    }

    public String getSelectedText() {
        return this.selection_.toString();
    }

    @Override
    public int getSelectionStart() {
        return this.selection_.getStartOffset();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        if (selectionStart < 0) {
            return;
        }
        int length = this.element_.getText().length();
        selectionStart = Math.max(0, Math.min(selectionStart, length));
        this.selection_.setStart((DomNode)((Object)this.element_), selectionStart);
        if (this.selection_.getEndOffset() < selectionStart) {
            this.selection_.setEnd((DomNode)((Object)this.element_), selectionStart);
        }
    }

    @Override
    public int getSelectionEnd() {
        return this.selection_.getEndOffset();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        int length = this.element_.getText().length();
        selectionEnd = Math.min(length, Math.max(selectionEnd, 0));
        this.selection_.setEnd((DomNode)((Object)this.element_), selectionEnd);
        if (this.selection_.getStartOffset() > selectionEnd) {
            this.selection_.setStart((DomNode)((Object)this.element_), selectionEnd);
        }
    }
}

