/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.xpath.HtmlUnitPrefixResolver;
import org.htmlunit.html.xpath.XPathAdapter;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.objects.XBoolean;
import org.htmlunit.xpath.objects.XNodeSet;
import org.htmlunit.xpath.objects.XNumber;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.objects.XString;
import org.htmlunit.xpath.xml.utils.PrefixResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private static final ThreadLocal<Boolean> PROCESS_XPATH_ = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private XPathHelper() {
    }

    public static <T> List<T> getByXPath(DomNode contextNode, String xpathExpr, PrefixResolver prefixResolver) {
        if (xpathExpr == null) {
            throw new IllegalArgumentException("Null is not a valid XPath expression");
        }
        PrefixResolver resolver = prefixResolver;
        if (resolver == null) {
            Node xpathExpressionContext = contextNode.getNodeType() == 9 ? ((Document)((Object)contextNode)).getDocumentElement() : contextNode;
            resolver = new HtmlUnitPrefixResolver(xpathExpressionContext);
        }
        try {
            boolean caseSensitive = contextNode.getPage().hasCaseSensitiveTagNames();
            XPathAdapter xpath = new XPathAdapter(xpathExpr, resolver, caseSensitive);
            return XPathHelper.getByXPath((Node)contextNode, xpath, prefixResolver);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve XPath >" + xpathExpr + "< on " + contextNode, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getByXPath(Node node, XPathAdapter xpath, PrefixResolver prefixResolver) throws TransformerException {
        ArrayList<Object> list;
        block8: {
            list = new ArrayList<Object>();
            PROCESS_XPATH_.set(Boolean.TRUE);
            try {
                XPathContext xpathSupport = new XPathContext();
                int ctxtNode = xpathSupport.getDTMHandleFromNode(node);
                XObject result = xpath.execute(xpathSupport, ctxtNode, prefixResolver);
                if (result instanceof XNodeSet) {
                    NodeList nodelist = result.nodelist();
                    int length = nodelist.getLength();
                    for (int i = 0; i < length; ++i) {
                        list.add(nodelist.item(i));
                    }
                    break block8;
                }
                if (result instanceof XNumber) {
                    list.add(result.num());
                    break block8;
                }
                if (result instanceof XBoolean) {
                    list.add(result.bool());
                    break block8;
                }
                if (result instanceof XString) {
                    list.add(result.str());
                    break block8;
                }
                throw new RuntimeException("Unproccessed " + result.getClass().getName());
            }
            finally {
                PROCESS_XPATH_.set(Boolean.FALSE);
            }
        }
        return list;
    }

    public static boolean isProcessingXPath() {
        return PROCESS_XPATH_.get();
    }
}

