/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.net.URL;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;

@JsxClass
public class MessagePort
extends EventTarget {
    private MessagePort port_;

    public MessagePort() {
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    public MessagePort(MessagePort port) {
        this.port_ = port;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getHandlerForJavaScript("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    private Function getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandler(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        this.getEventListenersContainer().setEventHandler(eventName, handler);
    }

    @JsxFunction
    public void postMessage(String message, Object transfer) {
        if (this.port_ != null) {
            Window w = this.getWindow();
            WebWindow webWindow = w.getWebWindow();
            Page page = webWindow.getEnclosedPage();
            final MessageEvent event = new MessageEvent();
            URL currentURL = page.getUrl();
            String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
            event.initMessageEvent("message", false, false, message, origin, "", w, transfer);
            event.setParentScope(this.port_);
            event.setPrototype(this.getPrototype(event.getClass()));
            final AbstractJavaScriptEngine<?> jsEngine = webWindow.getWebClient().getJavaScriptEngine();
            PostponedAction action = new PostponedAction(page, "MessagePort.postMessage"){

                @Override
                public void execute() {
                    HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                    cf.call(cx -> MessagePort.this.port_.dispatchEvent(event));
                }
            };
            jsEngine.addPostponedAction(action);
        }
    }
}

