/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.XPathExpression;
import org.htmlunit.javascript.host.dom.XPathNSResolver;
import org.htmlunit.javascript.host.dom.XPathResult;
import org.htmlunit.xpath.xml.utils.PrefixResolver;

@JsxClass
public class XPathEvaluator
extends HtmlUnitScriptable {
    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public XPathResult evaluate(String expression, Object contextNodeObj, Object resolver, int type, Object result) {
        try {
            XPathResult xPathResult;
            if (!(contextNodeObj instanceof Node)) {
                throw JavaScriptEngine.typeError("Illegal value for parameter 'context'");
            }
            Node contextNode = (Node)contextNodeObj;
            PrefixResolver prefixResolver = null;
            if (resolver instanceof PrefixResolver) {
                prefixResolver = (PrefixResolver)resolver;
            } else if (resolver instanceof NativeFunction) {
                prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
            }
            if (result instanceof XPathResult) {
                xPathResult = (XPathResult)result;
            } else {
                xPathResult = new XPathResult();
                xPathResult.setParentScope(this.getParentScope());
                xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
            }
            xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
            return xPathResult;
        }
        catch (Exception e) {
            throw JavaScriptEngine.typeError("Failed to execute 'evaluate': " + e.getMessage());
        }
    }

    @JsxFunction
    public static XPathExpression createExpression(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw JavaScriptEngine.reportRuntimeError("Missing 'expression' parameter");
        }
        PrefixResolver prefixResolver = null;
        if (args.length > 1) {
            Object resolver = args[1];
            if (resolver instanceof PrefixResolver) {
                prefixResolver = (PrefixResolver)resolver;
            } else if (resolver instanceof NativeFunction) {
                prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, scope.getParentScope());
            }
        }
        XPathEvaluator evaluator = (XPathEvaluator)thisObj;
        try {
            String xpath = JavaScriptEngine.toString(args[0]);
            DomElement doc = ((Window)scope).getDocument().getDocumentElement().getDomNodeOrDie();
            XPathExpression xPathExpression = new XPathExpression(xpath, prefixResolver, doc);
            xPathExpression.setParentScope(evaluator.getParentScope());
            xPathExpression.setPrototype(evaluator.getPrototype(xPathExpression.getClass()));
            return xPathExpression;
        }
        catch (Exception e) {
            throw JavaScriptEngine.syntaxError("Failed to compile xpath '" + args[0] + "' (" + e.getMessage() + ")");
        }
    }
}

