/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.Locale;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.util.StringUtils;

@JsxClass
public class FileReader
extends EventTarget {
    private static final Log LOG = LogFactory.getLog(FileReader.class);
    @JsxConstant
    public static final int EMPTY = 0;
    @JsxConstant
    public static final int LOADING = 1;
    @JsxConstant
    public static final int DONE = 2;
    private int readyState_ = 0;
    private Object result_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxGetter
    public Object getResult() {
        return this.result_;
    }

    @JsxFunction
    public void readAsDataURL(Object object) throws IOException {
        this.readyState_ = 1;
        this.result_ = "data:";
        byte[] bytes = ((Blob)object).getBytes();
        String value = new String(Base64.getEncoder().encode(bytes), StandardCharsets.US_ASCII);
        String contentType = ((Blob)object).getType();
        if (StringUtils.isEmptyOrNull(contentType)) {
            contentType = "application/octet-stream";
        }
        this.result_ = this.result_ + contentType + ";base64," + value;
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsArrayBuffer(Object object) {
        this.readyState_ = 1;
        if (object instanceof Blob) {
            byte[] bytes = ((Blob)object).getBytes();
            NativeArrayBuffer buffer = new NativeArrayBuffer((double)bytes.length);
            System.arraycopy(bytes, 0, buffer.getBuffer(), 0, bytes.length);
            buffer.setParentScope(this.getParentScope());
            buffer.setPrototype(ScriptableObject.getClassPrototype(this.getWindow(), buffer.getClassName()));
            this.result_ = buffer;
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsText(Object object, Object encoding) {
        Charset charset;
        block4: {
            String encAsString;
            this.readyState_ = 1;
            charset = StandardCharsets.UTF_8;
            if (encoding != null && !JavaScriptEngine.isUndefined(encoding) && StringUtils.isNotBlank(encAsString = JavaScriptEngine.toString(encoding))) {
                try {
                    charset = Charsets.toCharset((String)encAsString.trim().toLowerCase(Locale.ROOT));
                }
                catch (UnsupportedCharsetException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)("FileReader readAsText was called with an unsupported encoding '" + encoding + "'. Using UTF-8 instead."));
                }
            }
        }
        if (object instanceof Blob) {
            this.result_ = new String(((Blob)object).getBytes(), charset);
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxGetter
    public Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setEventHandler("error", onerror);
    }
}

