/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util.brotli;

final class Huffman {
    private static final int MAX_LENGTH = 15;

    Huffman() {
    }

    private static int getNextKey(int key, int len) {
        int step = 1 << len - 1;
        while ((key & step) != 0) {
            step >>= 1;
        }
        return (key & step - 1) + step;
    }

    private static void replicateValue(int[] table, int offset, int step, int end, int item) {
        int pos = end;
        while (pos > 0) {
            table[offset + (pos -= step)] = item;
        }
    }

    private static int nextTableBitSize(int[] count, int len, int rootBits) {
        int bits = len;
        int left = 1 << bits - rootBits;
        while (bits < 15 && (left -= count[bits]) > 0) {
            ++bits;
            left <<= 1;
        }
        return bits - rootBits;
    }

    static int buildHuffmanTable(int[] tableGroup, int tableIdx, int rootBits, int[] codeLengths, int codeLengthsSize) {
        int tableSize;
        int sym;
        int tableOffset = tableGroup[tableIdx];
        int[] sorted = new int[codeLengthsSize];
        int[] count = new int[16];
        int[] offset = new int[16];
        for (sym = 0; sym < codeLengthsSize; ++sym) {
            int n = codeLengths[sym];
            count[n] = count[n] + 1;
        }
        offset[1] = 0;
        for (int len = 1; len < 15; ++len) {
            offset[len + 1] = offset[len] + count[len];
        }
        for (sym = 0; sym < codeLengthsSize; ++sym) {
            if (codeLengths[sym] == 0) continue;
            int n = codeLengths[sym];
            int n2 = offset[n];
            offset[n] = n2 + 1;
            sorted[n2] = sym;
        }
        int tableBits = rootBits;
        int totalSize = tableSize = 1 << tableBits;
        if (offset[15] == 1) {
            for (int k = 0; k < totalSize; ++k) {
                tableGroup[tableOffset + k] = sorted[0];
            }
            return totalSize;
        }
        int key = 0;
        int symbol = 0;
        int step = 1;
        for (int len = 1; len <= rootBits; ++len) {
            step <<= 1;
            while (count[len] > 0) {
                Huffman.replicateValue(tableGroup, tableOffset + key, step, tableSize, len << 16 | sorted[symbol++]);
                key = Huffman.getNextKey(key, len);
                int n = len;
                count[n] = count[n] - 1;
            }
        }
        int mask = totalSize - 1;
        int low = -1;
        int currentOffset = tableOffset;
        step = 1;
        for (int len = rootBits + 1; len <= 15; ++len) {
            step <<= 1;
            while (count[len] > 0) {
                if ((key & mask) != low) {
                    tableBits = Huffman.nextTableBitSize(count, len, rootBits);
                    tableSize = 1 << tableBits;
                    totalSize += tableSize;
                    low = key & mask;
                    tableGroup[tableOffset + low] = tableBits + rootBits << 16 | (currentOffset += tableSize) - tableOffset - low;
                }
                Huffman.replicateValue(tableGroup, currentOffset + (key >> rootBits), step, tableSize, len - rootBits << 16 | sorted[symbol++]);
                key = Huffman.getNextKey(key, len);
                int n = len;
                count[n] = count[n] - 1;
            }
        }
        return totalSize;
    }
}

