/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.serializer;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlDetails;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSummary;
import com.gargoylesoftware.htmlunit.html.HtmlSvg;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.svg.SvgText;
import com.gargoylesoftware.htmlunit.svg.SvgTitle;
import org.apache.commons.lang3.StringUtils;

public class HtmlSerializerInnerOuterText {
    private final BrowserVersion browserVersion_;

    public HtmlSerializerInnerOuterText(BrowserVersion browserVersion) {
        this.browserVersion_ = browserVersion;
    }

    public String asText(DomNode node) {
        if (node instanceof HtmlBreak) {
            return "";
        }
        HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
        this.appendNode(builder, node, HtmlSerializerInnerOuterText.whiteSpaceStyle(node, HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL));
        return builder.getText();
    }

    protected void appendChildren(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child, mode);
        }
    }

    protected void appendNode(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node, mode);
        } else if (node instanceof HtmlBreak) {
            this.appendBreak(builder, (HtmlBreak)node);
        } else if (node instanceof HtmlParagraph) {
            this.appendParagraph(builder, (HtmlParagraph)node, mode);
        } else if (node instanceof HtmlListItem) {
            this.appendListItem(builder, (HtmlListItem)node, mode);
        } else if (node instanceof HtmlDetails) {
            this.appendDetails(builder, (HtmlDetails)node, mode);
        } else if (node instanceof HtmlNoFrames) {
            this.appendChildren(builder, node, HtmlSerializerTextBuilder.Mode.PLAIN);
        } else if (!(node instanceof HtmlTextArea)) {
            if (node instanceof HtmlSvg) {
                if (this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_SVG_NL)) {
                    builder.appendRequiredLineBreak();
                    this.appendChildren(builder, node, mode);
                    builder.appendRequiredLineBreak();
                } else {
                    this.appendChildren(builder, node, mode);
                }
            } else if (node instanceof SvgText) {
                this.appendChildren(builder, node, mode);
            } else if (node instanceof SvgTitle) {
                if (this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_SVG_TITLE)) {
                    this.appendChildren(builder, node, mode);
                }
            } else {
                this.appendChildren(builder, node, mode);
            }
        }
    }

    protected void appendText(HtmlSerializerTextBuilder builder, DomText domText, HtmlSerializerTextBuilder.Mode mode) {
        DomNode parent = domText.getParentNode();
        if (parent instanceof HtmlTitle || parent instanceof HtmlStyle || parent instanceof HtmlScript) {
            builder.append(domText.getData(), HtmlSerializerTextBuilder.Mode.PLAIN);
            return;
        }
        if (parent == null || parent instanceof HtmlNoFrames || parent.isDisplayed()) {
            builder.append(domText.getData(), mode);
        }
    }

    protected void appendBreak(HtmlSerializerTextBuilder builder, HtmlBreak htmlBreak) {
        builder.appendRequiredLineBreak();
    }

    protected void appendParagraph(HtmlSerializerTextBuilder builder, HtmlParagraph htmlParagraph, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendRequiredLineBreak();
        this.appendChildren(builder, htmlParagraph, mode);
        builder.appendRequiredLineBreak();
    }

    protected void appendListItem(HtmlSerializerTextBuilder builder, HtmlListItem htmlListItem, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendRequiredLineBreak();
        this.appendChildren(builder, htmlListItem, mode);
        builder.appendRequiredLineBreak();
    }

    protected void appendDetails(HtmlSerializerTextBuilder builder, HtmlDetails htmlDetails, HtmlSerializerTextBuilder.Mode mode) {
        if (htmlDetails.isOpen()) {
            this.appendChildren(builder, htmlDetails, mode);
            return;
        }
        for (DomNode child : htmlDetails.getChildren()) {
            if (!(child instanceof HtmlSummary)) continue;
            this.appendNode(builder, child, mode);
        }
    }

    private static HtmlSerializerTextBuilder.Mode whiteSpaceStyle(DomNode domNode, HtmlSerializerTextBuilder.Mode defaultMode) {
        SgmlPage page;
        Object scriptableObject = domNode.getScriptableObject();
        if (scriptableObject instanceof Node && (page = domNode.getPage()) != null && page.getEnclosingWindow().getWebClient().getOptions().isCssEnabled()) {
            for (Node node = (Node)scriptableObject; node != null; node = node.getParentElement()) {
                CSS2Properties style;
                String value;
                if (!(node instanceof Element) || !StringUtils.isNoneEmpty(value = (style = node.getWindow().getComputedStyle(node, null)).getStyleAttribute(StyleAttributes.Definition.WHITE_SPACE, false))) continue;
                if ("normal".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("nowrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("pre".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if ("pre-wrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if (!"pre-line".equalsIgnoreCase(value)) continue;
                return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE_LINE;
            }
        }
        return defaultMode;
    }

    protected static class HtmlSerializerTextBuilder {
        private State state_;
        private final StringBuilder builder_ = new StringBuilder();
        private int trimRightPos_ = 0;

        public HtmlSerializerTextBuilder() {
            this.state_ = State.EMPTY;
        }

        public void appendRequiredLineBreak() {
            if (this.state_ == State.EMPTY) {
                return;
            }
            this.builder_.setLength(this.trimRightPos_);
            if (this.trimRightPos_ == 0) {
                this.state_ = State.EMPTY;
            }
            this.builder_.append('\n');
            this.state_ = State.REQUIRED_LINE_BREAK_AT_END;
        }

        public void append(String content, Mode mode) {
            int length = content.length();
            if (length == 0) {
                return;
            }
            if (mode == Mode.PLAIN) {
                this.builder_.append(content);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
                return;
            }
            --length;
            int i = -1;
            for (char c : content.toCharArray()) {
                ++i;
                if (c == '\r') {
                    if (length != i) continue;
                    c = '\n';
                }
                if (c == '\n') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            case BLANK_AT_END: {
                                this.builder_.setLength(this.trimRightPos_);
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: 
                        case REQUIRED_LINE_BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\f') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        if (c == '\t') {
                            this.builder_.append('\t');
                        } else {
                            this.builder_.append(' ');
                        }
                        this.state_ = State.BLANK_AT_END;
                        this.trimRightPos_ = this.builder_.length();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLANK_AT_END: 
                            case BLANK_AT_END_AFTER_NEWLINE: 
                            case NEWLINE_AT_END: 
                            case BREAK_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: 
                        case REQUIRED_LINE_BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                this.builder_.append(c);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
            }
        }

        public String getText() {
            return this.builder_.substring(0, this.trimRightPos_);
        }

        private static enum State {
            DEFAULT,
            EMPTY,
            BLANK_AT_END,
            BLANK_AT_END_AFTER_NEWLINE,
            NEWLINE_AT_END,
            BREAK_AT_END,
            BLOCK_SEPARATOR_AT_END,
            REQUIRED_LINE_BREAK_AT_END;

        }

        protected static enum Mode {
            PLAIN,
            WHITE_SPACE_NORMAL,
            WHITE_SPACE_PRE,
            WHITE_SPACE_PRE_LINE;

        }
    }
}

