/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;

@JsxClass
public class MediaList
extends SimpleScriptable {
    private final MediaListImpl wrappedList_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public MediaList() {
        this.wrappedList_ = null;
    }

    public MediaList(CSSStyleSheet parent, MediaListImpl wrappedList) {
        this.wrappedList_ = wrappedList;
        this.setParentScope(parent);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxFunction
    public String item(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        MediaQuery mq = this.wrappedList_.mediaQuery(index);
        return mq.toString();
    }

    @JsxGetter
    public int getLength() {
        return this.wrappedList_.getLength();
    }

    @JsxGetter
    public String getMediaText() {
        return this.wrappedList_.getMediaText();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && this.wrappedList_ != null) {
            if (this.wrappedList_.getLength() == 0) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_EMPTY_STRING)) {
                    return "";
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_ALL)) {
                    return "all";
                }
            }
            return this.wrappedList_.getMediaText();
        }
        return super.getDefaultValue(hint);
    }
}

