/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jvnet.hudson.test.JellyTestSuiteBuilder;

public class PropertiesTestSuite
extends TestSuite {
    public PropertiesTestSuite(File resources) throws IOException {
        for (Map.Entry<URL, String> entry : JellyTestSuiteBuilder.scan(resources, "properties").entrySet()) {
            this.addTest((Test)new PropertiesTest(entry.getKey(), entry.getValue()));
        }
    }

    private static class PropertiesTest
    extends TestCase {
        private final URL resource;

        private PropertiesTest(URL resource, String name) {
            super(name);
            this.resource = resource;
        }

        protected void runTest() throws Throwable {
            Properties props = new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    Object old = super.put(key, value);
                    if (old != null) {
                        throw new AssertionError((Object)("Two values for `" + key + "` (`" + old + "` vs. `" + value + "`) in " + PropertiesTest.this.resource));
                    }
                    return null;
                }
            };
            InputStream is = this.resource.openStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
    }
}

