/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.Assert;

public interface WebResponseListener {
    public void onLoadWebResponse(WebRequest var1, WebResponse var2) throws IOException;

    public static final class StatusListener
    implements WebResponseListener {
        private final int statusCode;
        private final List<WebResponse> responses = new CopyOnWriteArrayList<WebResponse>();

        public StatusListener(int statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public void onLoadWebResponse(WebRequest webRequest, WebResponse webResponse) throws IOException {
            if (webResponse.getStatusCode() == this.statusCode) {
                this.responses.add(webResponse);
            }
        }

        public void assertHasResponses() {
            Assert.assertTrue((!this.responses.isEmpty() ? 1 : 0) != 0);
        }

        public List<WebResponse> getResponses() {
            return this.responses;
        }
    }
}

