/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.util.RingBufferLogHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.ExternalResource;
import org.jvnet.hudson.test.SupportLogFormatter;

public class LoggerRule
extends ExternalResource {
    private final Handler consoleHandler = new ConsoleHandler();
    private final Map<Logger, Level> loggers = new HashMap<Logger, Level>();
    private RingBufferLogHandler ringHandler;
    private List<String> messages;

    public LoggerRule() {
        this.consoleHandler.setFormatter(new SupportLogFormatter());
        this.consoleHandler.setLevel(Level.ALL);
    }

    public LoggerRule capture(int maximum) {
        this.messages = new ArrayList<String>();
        this.ringHandler = new RingBufferLogHandler(maximum){
            final Formatter f;
            {
                this.f = new SimpleFormatter();
            }

            public synchronized void publish(LogRecord record) {
                super.publish(record);
                String message = this.f.formatMessage(record);
                Throwable x = record.getThrown();
                LoggerRule.this.messages.add(message == null && x != null ? x.toString() : message);
            }
        };
        this.ringHandler.setLevel(Level.ALL);
        for (Logger logger : this.loggers.keySet()) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LoggerRule record(Logger logger, Level level) {
        this.loggers.put(logger, logger.getLevel());
        logger.setLevel(level);
        logger.addHandler(this.consoleHandler);
        if (this.ringHandler != null) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LoggerRule record(String name, Level level) {
        return this.record(Logger.getLogger(name), level);
    }

    public LoggerRule record(Class<?> clazz, Level level) {
        return this.record(clazz.getName(), level);
    }

    public LoggerRule recordPackage(Class<?> clazz, Level level) {
        return this.record(clazz.getPackage().getName(), level);
    }

    public List<LogRecord> getRecords() {
        return this.ringHandler.getView();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    protected void after() {
        for (Map.Entry<Logger, Level> entry : this.loggers.entrySet()) {
            Logger logger = entry.getKey();
            logger.setLevel(entry.getValue());
            logger.removeHandler(this.consoleHandler);
            if (this.ringHandler == null) continue;
            logger.removeHandler((Handler)this.ringHandler);
        }
        this.loggers.clear();
        if (this.ringHandler != null) {
            this.ringHandler.clear();
            this.messages.clear();
        }
    }

    public static Matcher<LoggerRule> recorded(@CheckForNull Level level, @Nonnull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
        return new RecordedMatcher(level, message, thrown);
    }

    public static Matcher<LoggerRule> recorded(@CheckForNull Level level, @Nonnull Matcher<String> message) {
        return LoggerRule.recorded(level, message, null);
    }

    public static Matcher<LoggerRule> recorded(@Nonnull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
        return LoggerRule.recorded(null, message, thrown);
    }

    public static Matcher<LoggerRule> recorded(@Nonnull Matcher<String> message) {
        return LoggerRule.recorded(null, message);
    }

    private static class RecordedMatcher
    extends TypeSafeMatcher<LoggerRule> {
        @CheckForNull
        Level level;
        @Nonnull
        Matcher<String> message;
        @CheckForNull
        Matcher<Throwable> thrown;

        public RecordedMatcher(@CheckForNull Level level, @Nonnull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
            this.level = level;
            this.message = message;
            this.thrown = thrown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean matchesSafely(LoggerRule item) {
            LoggerRule loggerRule = item;
            synchronized (loggerRule) {
                for (LogRecord record : item.getRecords()) {
                    if (this.level != null && record.getLevel() != this.level || !this.message.matches((Object)record.getMessage())) continue;
                    if (this.thrown != null) {
                        if (!this.thrown.matches((Object)record.getThrown())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("has LogRecord");
            if (this.level != null) {
                description.appendText(" with level ");
                description.appendValue((Object)this.level.getName());
            }
            description.appendText(" with a message matching ");
            description.appendDescriptionOf(this.message);
            if (this.thrown != null) {
                description.appendText(" with an exception matching ");
                description.appendDescriptionOf(this.thrown);
            }
        }
    }
}

