/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;

public final class WarExploder {
    private static final Logger LOGGER = Logger.getLogger(WarExploder.class.getName());
    public static final String JENKINS_WAR_PATH_PROPERTY_NAME = "jth.jenkins-war.path";
    @CheckForNull
    private static final String JENKINS_WAR_PATH = System.getProperty("jth.jenkins-war.path");
    private static File EXPLODE_DIR;
    private static Exception FAILURE;

    public static File getExplodedDir() throws Exception {
        if (FAILURE != null) {
            throw new Exception("Failed to initialize exploded war", FAILURE);
        }
        return EXPLODE_DIR;
    }

    private static File explode() throws Exception {
        File war;
        for (File d = new File(".").getAbsoluteFile(); d != null; d = d.getParentFile()) {
            File dir;
            if (!new File(d, ".jenkins").exists() || !(dir = new File(d, "war/target/jenkins")).exists()) continue;
            LOGGER.log(Level.INFO, "Using jenkins.war resources from {0}", dir);
            return dir;
        }
        if (JENKINS_WAR_PATH != null) {
            war = new File(JENKINS_WAR_PATH).getAbsoluteFile();
            LOGGER.log(Level.INFO, "Using a predefined WAR file {0} define by the {1} system property", new Object[]{war, JENKINS_WAR_PATH_PROPERTY_NAME});
            if (!war.exists()) {
                throw new IOException("A Predefined WAR file path does not exist: " + war);
            }
            if (!war.isFile()) {
                throw new IOException("A Predefined WAR file path does not point to a file: " + war);
            }
        } else {
            URL winstone = WarExploder.class.getResource("/winstone.jar");
            if (winstone != null) {
                war = Which.jarFile(Class.forName("executable.Executable"));
            } else {
                File core = Which.jarFile(Jenkins.class);
                String version = core.getParentFile().getName();
                if (core.getName().equals("jenkins-core-" + version + ".jar") && core.getParentFile().getParentFile().getName().equals("jenkins-core")) {
                    war = new File(new File(new File(core.getParentFile().getParentFile().getParentFile(), "jenkins-war"), version), "jenkins-war-" + version + ".war");
                    if (!war.isFile()) {
                        throw new AssertionError((Object)(war + " does not yet exist. Prime your development environment by running `mvn validate`."));
                    }
                    LOGGER.log(Level.FINE, "{0} is the continuation of the classpath by other means", war);
                } else {
                    throw new AssertionError((Object)(core + " is not in the expected location, and jenkins-war-*.war was not in " + System.getProperty("java.class.path")));
                }
            }
        }
        File buildDirectory = new File(System.getProperty("buildDirectory", "target"));
        File explodeDir = new File(buildDirectory, "jenkins-for-test").getAbsoluteFile();
        explodeDir.getParentFile().mkdirs();
        while (new File(explodeDir + ".exploding").isFile()) {
            explodeDir = new File(explodeDir + "x");
        }
        File timestamp = new File(explodeDir, ".timestamp");
        if (!timestamp.exists() || timestamp.lastModified() != war.lastModified()) {
            LOGGER.log(Level.INFO, "Exploding {0} into {1}", new Object[]{war, explodeDir});
            new FileOutputStream(explodeDir + ".exploding").close();
            new FilePath(explodeDir).deleteRecursive();
            new FilePath(war).unzip(new FilePath(explodeDir));
            if (!explodeDir.exists()) {
                throw new IOException("Failed to explode " + war);
            }
            new FileOutputStream(timestamp).close();
            timestamp.setLastModified(war.lastModified());
            new File(explodeDir + ".exploding").delete();
        } else {
            LOGGER.log(Level.INFO, "Picking up existing exploded jenkins.war at {0}", explodeDir.getAbsolutePath());
        }
        return explodeDir;
    }

    private WarExploder() {
    }

    static {
        try {
            EXPLODE_DIR = WarExploder.explode();
        }
        catch (Exception e) {
            FAILURE = e;
        }
    }
}

