/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Util;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JavaNetReverseProxy
extends HttpServlet {
    private final Server server;
    public final int localPort;
    private final File cacheFolder;
    private static volatile JavaNetReverseProxy INSTANCE;

    public JavaNetReverseProxy(File cacheFolder) throws Exception {
        this.cacheFolder = cacheFolder;
        cacheFolder.mkdirs();
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setName("Jetty (JavaNetReverseProxy)");
        this.server = new Server((ThreadPool)qtp);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)this), "/");
        ServerConnector connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)connector);
        this.server.start();
        this.localPort = connector.getLocalPort();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getServletPath();
        String d = Util.getDigestOf((String)path);
        File cache = new File(this.cacheFolder, d);
        if (!cache.exists()) {
            URL url = new URL("http://updates.jenkins-ci.org/" + path);
            FileUtils.copyURLToFile((URL)url, (File)cache);
        }
        resp.setContentType(this.getMimeType(path));
        IOUtils.copy((File)cache, (OutputStream)resp.getOutputStream());
    }

    private String getMimeType(String path) {
        int idx = path.indexOf(63);
        if (idx >= 0) {
            path = path.substring(0, idx);
        }
        if (path.endsWith(".json")) {
            return "text/javascript";
        }
        return this.getServletContext().getMimeType(path);
    }

    public static synchronized JavaNetReverseProxy getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new JavaNetReverseProxy(new File(new File(System.getProperty("java.io.tmpdir")), "jenkins-ci.org-cache2"));
        }
        return INSTANCE;
    }
}

