/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.remoting.DelegatingCallable;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    protected final List<String> goals;
    protected final Map<String, String> systemProps;
    protected final BuildListener listener;

    protected AbstractMavenBuilder(BuildListener listener, List<String> goals, Map<String, String> systemProps) {
        this.listener = listener;
        this.goals = goals;
        this.systemProps = systemProps;
    }

    protected String formatArgs(List<String> args) {
        StringBuilder buf = new StringBuilder("Executing Maven: ");
        for (String arg : args) {
            String argPassword = "-Dpassword=";
            String filteredArg = arg;
            if (arg.startsWith("-Dpassword=")) {
                filteredArg = "-Dpassword=*********";
            }
            buf.append(' ').append(filteredArg);
        }
        return buf.toString();
    }

    protected String format(NumberFormat n, long nanoTime) {
        return n.format(nanoTime / 1000000L);
    }

    public ClassLoader getClassLoader() {
        return Hudson.getInstance().getPluginManager().uberClassLoader;
    }
}

