/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.ExecutedMojo;
import hudson.maven.FilteredChangeLogSet;
import hudson.maven.Maven3ProcessFactory;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenInformation;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenVersionCallable;
import hudson.maven.Messages;
import hudson.maven.MojoInfo;
import hudson.maven.ProcessCache;
import hudson.maven.SplittableBuildListener;
import hudson.maven.agent.AbortException;
import hudson.maven.reporters.SurefireArchiver;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuild
extends AbstractMavenBuild<MavenModule, MavenBuild> {
    List<MavenProjectActionBuilder> projectActionReporters;
    private List<ExecutedMojo> executedMojos;
    private String builtOn;
    private static final int MAX_PROCESS_CACHE = 5;
    protected static final ProcessCache mavenProcessCache = new ProcessCache(5);
    public static boolean debug = false;

    public MavenBuild(MavenModule job) throws IOException {
        super(job);
    }

    public MavenBuild(MavenModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public MavenBuild(MavenModule project, File buildDir) throws IOException {
        super(project, buildDir);
        SurefireArchiver.fixUp(this.projectActionReporters);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    public MavenModuleSetBuild getParentBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public MavenModuleSetBuild getModuleSetBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        String opts = ((MavenModule)this.project).getParent().getMavenOpts();
        if (opts != null) {
            envs.put("MAVEN_OPTS", opts);
        }
        return envs;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void registerAsProjectAction(MavenProjectActionBuilder builder) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(builder);
    }

    public List<MavenProjectActionBuilder> getProjectActionBuilders() {
        if (this.projectActionReporters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.projectActionReporters);
    }

    public List<ExecutedMojo> getExecutedMojos() {
        if (this.executedMojos == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.executedMojos);
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl());
        ((MavenModule)this.getProject()).updateTransientActions();
        MavenModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    public String getWhyKeepLog() {
        MavenModuleSetBuild pb = this.getParentBuild();
        if (pb != null && pb.getWhyKeepLog() != null) {
            return Messages.MavenBuild_KeptBecauseOfParent((Object)pb);
        }
        return super.getWhyKeepLog();
    }

    public static ExecutedMojo.Cache createExecutedMojoCache() {
        return new ExecutedMojo.Cache();
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public Node getBuiltOn() {
        if (this.builtOn == null || this.builtOn.equals("")) {
            return Hudson.getInstance();
        }
        return Hudson.getInstance().getNode(this.builtOn);
    }

    public void setBuiltOnStr(String builtOn) {
        this.builtOn = builtOn;
    }

    public MavenModule getParent() {
        return (MavenModule)super.getParent();
    }

    private class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        private List<MavenReporter> reporters;

        private RunnerImpl() {
            super((AbstractBuild)MavenBuild.this);
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.allocate(MavenBuild.this.getModuleSetBuild().getModuleRoot().child(((MavenModule)MavenBuild.this.getProject()).getRelativePath()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result doRun(BuildListener listener) throws Exception {
            this.reporters = ((MavenModule)MavenBuild.this.getProject()).createReporters();
            MavenModuleSet mms = ((MavenModule)MavenBuild.this.getProject()).getParent();
            if (debug) {
                listener.getLogger().println("Reporters=" + this.reporters);
            }
            for (BuildWrapper w : mms.getBuildWrappersList()) {
                BuildWrapper.Environment e = w.setUp((AbstractBuild)MavenBuild.this, this.launcher, listener);
                if (e == null) {
                    return Result.FAILURE;
                }
                MavenBuild.this.buildEnvironments.add(e);
            }
            EnvVars envVars = MavenBuild.this.getEnvironment((TaskListener)listener);
            Maven.MavenInstallation mvn = ((MavenModule)MavenBuild.this.getProject()).getParent().getMaven();
            mvn = mvn.forEnvironment(envVars).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            MavenInformation mavenInformation = (MavenInformation)MavenBuild.this.getModuleRoot().act((Callable)new MavenVersionCallable(mvn.getHome()));
            String mavenVersion = mavenInformation.getVersion();
            listener.getLogger().println("Found mavenVersion " + mavenVersion + " from file " + mavenInformation.getVersionResourcePath());
            ProcessCache.MavenProcess process = null;
            boolean maven3orLater = new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
            process = maven3orLater ? mavenProcessCache.get(this.launcher.getChannel(), listener, new Maven3ProcessFactory(MavenBuild.this.getParent().getParent(), this.launcher, envVars, null)) : mavenProcessCache.get(this.launcher.getChannel(), listener, new MavenProcessFactory(MavenBuild.this.getParent().getParent(), this.launcher, envVars, null));
            ArgumentListBuilder margs = new ArgumentListBuilder(new String[]{"-N", "-B"});
            if (mms.usesPrivateRepository()) {
                margs.add("-Dmaven.repo.local=" + MavenBuild.this.getWorkspace().child(".repository").getRemote());
            }
            if (mms.getAlternateSettings() != null) {
                if (IOUtils.isAbsolute((String)mms.getAlternateSettings())) {
                    margs.add("-s").add(mms.getAlternateSettings());
                } else {
                    FilePath mrSettings = MavenBuild.this.getModuleRoot().child(mms.getAlternateSettings());
                    FilePath wsSettings = MavenBuild.this.getWorkspace().child(mms.getAlternateSettings());
                    if (!wsSettings.exists() && mrSettings.exists()) {
                        wsSettings = mrSettings;
                    }
                    margs.add("-s").add(wsSettings.getRemote());
                }
            }
            margs.add(new String[]{"-f", MavenBuild.this.getModuleRoot().child("pom.xml").getRemote()});
            margs.addTokenized(((MavenModule)MavenBuild.this.getProject()).getGoals());
            HashMap<String, String> systemProps = new HashMap<String, String>((Map<String, String>)envVars);
            systemProps.put("hudson.build.number", String.valueOf(MavenBuild.this.getNumber()));
            boolean normalExit = false;
            if (maven3orLater) {
                return Result.ABORTED;
            }
            try {
                Result r = (Result)process.call(new Builder(listener, new ProxyImpl(), this.reporters.toArray(new MavenReporter[this.reporters.size()]), margs.toList(), systemProps));
                normalExit = true;
                Result result = r;
                return result;
            }
            finally {
                if (normalExit) {
                    process.recycle();
                } else {
                    process.discard();
                }
                boolean failed = false;
                for (int i = MavenBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                    if (((Environment)MavenBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)MavenBuild.this, listener)) continue;
                    failed = true;
                }
                if (failed) {
                    return Result.FAILURE;
                }
            }
        }

        public void post2(BuildListener listener) throws Exception {
            for (MavenReporter reporter : this.reporters) {
                reporter.end(MavenBuild.this, this.launcher, listener);
            }
        }
    }

    public class ProxyImpl2
    extends ProxyImpl
    implements MavenBuildProxy2 {
        private final SplittableBuildListener listener;
        long startTime;
        private final OutputStream log;
        private final MavenModuleSetBuild parentBuild;

        ProxyImpl2(MavenModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(MavenBuild.this.getLogFile());
        }

        public void start() {
            MavenBuild.this.onStartBuilding();
            this.startTime = System.currentTimeMillis();
            try {
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void end() {
            if (MavenBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            MavenBuild.this.onEndBuilding();
            MavenBuild.this.duration += System.currentTimeMillis() - this.startTime;
            this.parentBuild.notifyModuleBuild(MavenBuild.this);
            try {
                this.listener.setSideOutputStream(null);
                MavenBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void appendLastLog() {
            try {
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected void close() {
            try {
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (MavenBuild.this.hasntStartedYet()) {
                MavenBuild.this.run(new Run.Runner(){

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.MavenBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }

                    public void post(BuildListener listener) {
                    }

                    public void cleanUp(BuildListener listener) {
                    }
                });
            }
        }

        public MavenBuild owner() {
            return MavenBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy2.class, Executor.currentExecutor().newImpersonatingProxy(MavenBuildProxy2.class, (Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyImpl
    implements MavenBuildProxy,
    Serializable {
        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(MavenBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(MavenBuild.this);
        }

        @Override
        public final void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        @Override
        public FilePath getRootDir() {
            return new FilePath(MavenBuild.this.getRootDir());
        }

        @Override
        public FilePath getProjectRootDir() {
            return new FilePath(MavenBuild.this.getParent().getRootDir());
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return new FilePath(MavenBuild.this.getParent().getParent().getRootDir());
        }

        @Override
        public FilePath getArtifactsDir() {
            return new FilePath(MavenBuild.this.getArtifactsDir());
        }

        @Override
        public void setResult(Result result) {
            MavenBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return MavenBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(MavenReporter reporter) {
            MavenBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsProjectAction(MavenProjectActionBuilder builder) {
            MavenBuild.this.registerAsProjectAction(builder);
        }

        @Override
        public void registerAsAggregatedProjectAction(MavenReporter reporter) {
            MavenModuleSetBuild pb = MavenBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        @Override
        public void setExecutedMojos(List<ExecutedMojo> executedMojos) {
            MavenBuild.this.executedMojos = executedMojos;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy.class, (Object)this);
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return new MavenBuildInformation(MavenBuild.this.getModuleSetBuild().getMavenVersionUsed());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Builder
    extends MavenBuilder {
        private final MavenBuildProxy buildProxy;
        private final MavenReporter[] reporters;
        private final List<ExecutedMojo> executedMojos = new ArrayList<ExecutedMojo>();
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, MavenBuildProxy buildProxy, MavenReporter[] reporters, List<String> goals, Map<String, String> systemProps) {
            super(listener, goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.reporters = reporters;
        }

        @Override
        void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            for (MavenReporter r : this.reporters) {
                r.preBuild(this.buildProxy, rm.getTopLevelProject(), this.listener);
            }
        }

        @Override
        void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            this.buildProxy.setExecutedMojos(this.executedMojos);
            for (MavenReporter r : this.reporters) {
                r.postBuild(this.buildProxy, rm.getTopLevelProject(), this.listener);
            }
        }

        @Override
        void preExecute(MavenProject project, MojoInfo info) throws IOException, InterruptedException, AbortException {
            for (MavenReporter r : this.reporters) {
                if (r.preExecute(this.buildProxy, project, info, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
            this.startTime = System.currentTimeMillis();
        }

        @Override
        void postExecute(MavenProject project, MojoInfo info, Exception exception) throws IOException, InterruptedException, AbortException {
            this.executedMojos.add(new ExecutedMojo(info, System.currentTimeMillis() - this.startTime));
            for (MavenReporter r : this.reporters) {
                if (r.postExecute(this.buildProxy, project, info, this.listener, exception)) continue;
                throw new AbortException(r + " failed");
            }
        }

        @Override
        void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, AbortException {
            for (MavenReporter r : this.reporters) {
                if (r.reportGenerated(this.buildProxy, project, report, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        @Override
        void preModule(MavenProject project) throws InterruptedException, IOException, AbortException {
            for (MavenReporter r : this.reporters) {
                if (r.enterModule(this.buildProxy, project, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        @Override
        void postModule(MavenProject project) throws InterruptedException, IOException, AbortException {
            for (MavenReporter r : this.reporters) {
                if (r.leaveModule(this.buildProxy, project, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterImpl
        extends MavenBuildProxy.Filter<MavenBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(MavenBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.futures.add(Channel.current().callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }

            @Override
            public MavenBuildInformation getMavenBuildInformation() {
                return this.core.getMavenBuildInformation();
            }
        }
    }
}

