/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AggregatableAction;
import hudson.maven.ExecutedMojo;
import hudson.maven.Maven3Builder;
import hudson.maven.Maven3ProcessFactory;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenInformation;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProbeAction;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenUtil;
import hudson.maven.MavenVersionCallable;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.PomInfo;
import hudson.maven.ProcessCache;
import hudson.maven.ReactorReader;
import hudson.maven.SplittableBuildListener;
import hudson.maven.reporters.MavenFingerprinter;
import hudson.maven.reporters.MavenMailer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Fingerprint;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildWrapper;
import hudson.tasks.MailSender;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOUtils;
import hudson.util.MaskingClassLoader;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.PathTool;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModuleSetBuild
extends AbstractMavenBuild<MavenModuleSet, MavenModuleSetBuild> {
    List<MavenReporter> projectActionReporters;
    private String mavenVersionUsed;
    private static final Logger LOGGER = Logger.getLogger(MavenModuleSetBuild.class.getName());
    public static boolean debug = Boolean.getBoolean("hudson.maven.debug");

    public MavenModuleSetBuild(MavenModuleSet job) throws IOException {
        super(job);
    }

    public MavenModuleSetBuild(MavenModuleSet project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        String opts = ((MavenModuleSet)this.project).getMavenOpts();
        if (opts != null) {
            envs.put("MAVEN_OPTS", opts);
        }
        return envs;
    }

    public Result getResult() {
        Result r = super.getResult();
        for (MavenBuild b : this.getModuleLastBuilds().values()) {
            Result br = b.getResult();
            if (r == null) {
                r = br;
                continue;
            }
            if (br == Result.NOT_BUILT || br == null) continue;
            r = r.combine(br);
        }
        return r;
    }

    List<ChangeLogSet.Entry> getChangeSetFor(final MavenModule mod) {
        return new ArrayList<ChangeLogSet.Entry>(){
            {
                List<MavenModule> subsidiaries = null;
                for (ChangeLogSet.Entry e : MavenModuleSetBuild.this.getChangeSet()) {
                    if (!this.isDescendantOf(e, mod)) continue;
                    if (subsidiaries == null) {
                        subsidiaries = mod.getSubsidiaries();
                    }
                    if (!this.notInSubsidiary(subsidiaries, e)) continue;
                    this.add(e);
                }
            }

            private boolean notInSubsidiary(List<MavenModule> subsidiaries, ChangeLogSet.Entry e) {
                for (String path : e.getAffectedPaths()) {
                    if (this.belongsToSubsidiary(subsidiaries, path)) continue;
                    return true;
                }
                return false;
            }

            private boolean belongsToSubsidiary(List<MavenModule> subsidiaries, String path) {
                for (MavenModule sub : subsidiaries) {
                    if (!FilenameUtils.separatorsToUnix((String)path).startsWith(FilenameUtils.normalize((String)sub.getRelativePath()))) continue;
                    return true;
                }
                return false;
            }

            private boolean isDescendantOf(ChangeLogSet.Entry e, MavenModule mod2) {
                for (String path : e.getAffectedPaths()) {
                    if (!FilenameUtils.separatorsToUnix((String)path).startsWith(FilenameUtils.normalize((String)mod2.getRelativePath()))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Map<MavenModule, List<MavenBuild>> getModuleBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, List<MavenBuild>> r = new LinkedHashMap<MavenModule, List<MavenBuild>>(mods.size());
        for (MavenModule m : mods) {
            ArrayList<MavenBuild> builds = new ArrayList<MavenBuild>();
            for (MavenBuild b = (MavenBuild)m.getNearestBuild(this.number); b != null && b.getNumber() < end; b = (MavenBuild)b.getNextBuild()) {
                builds.add(b);
            }
            r.put(m, builds);
        }
        return r;
    }

    public long getEstimatedDuration() {
        if (!((MavenModuleSet)this.project).isIncrementalBuild()) {
            return super.getEstimatedDuration();
        }
        long result = 0L;
        Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            MavenBuild build;
            if (builds.isEmpty() || (build = builds.get(0)).getResult() == Result.NOT_BUILT || build.getEstimatedDuration() == -1L) continue;
            result += build.getEstimatedDuration();
        }
        return (result += this.estimateModuleSetBuildDurationOverhead(3)) != 0L ? result : -1L;
    }

    private long estimateModuleSetBuildDurationOverhead(int numberOfBuilds) {
        List moduleSetBuilds = this.getPreviousBuildsOverThreshold(numberOfBuilds, Result.UNSTABLE);
        if (moduleSetBuilds.isEmpty()) {
            return 0L;
        }
        long overhead = 0L;
        for (MavenModuleSetBuild moduleSetBuild : moduleSetBuilds) {
            long sumOfModuleBuilds = 0L;
            for (List<MavenBuild> builds : moduleSetBuild.getModuleBuilds().values()) {
                if (builds.isEmpty()) continue;
                MavenBuild moduleBuild = builds.get(0);
                sumOfModuleBuilds += moduleBuild.getDuration();
            }
            overhead += Math.max(0L, moduleSetBuild.getDuration() - sumOfModuleBuilds);
        }
        return Math.round((double)overhead / (double)moduleSetBuilds.size());
    }

    public String getMavenVersionUsed() {
        return this.mavenVersionUsed;
    }

    public void setMavenVersionUsed(String mavenVersionUsed) throws IOException {
        this.mavenVersionUsed = mavenVersionUsed;
        this.save();
    }

    public synchronized void delete() throws IOException {
        super.delete();
        for (List<MavenBuild> list : this.getModuleBuilds().values()) {
            for (MavenBuild build : list) {
                build.delete();
            }
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        MavenModule m;
        if (token.indexOf(36) > 0 && (m = ((MavenModuleSet)this.getProject()).getModule(token)) != null) {
            return m.getBuildByNumber(this.getNumber());
        }
        return super.getDynamic(token, req, rsp);
    }

    public Map<MavenModule, MavenBuild> getModuleLastBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, MavenBuild> r = new LinkedHashMap<MavenModule, MavenBuild>(mods.size());
        for (MavenModule m : mods) {
            MavenBuild b = (MavenBuild)m.getNearestOldBuild(end - 1);
            if (b == null || b.getNumber() < this.getNumber()) continue;
            r.put(m, b);
        }
        return r;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public <T extends Action> List<T> findModuleBuildActions(Class<T> action) {
        Collection<MavenModule> mods = this.getParent().getModules();
        ArrayList<Action> r = new ArrayList<Action>(mods.size());
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() - 1 : Integer.MAX_VALUE;
        block0: for (MavenModule m : mods) {
            for (MavenBuild b = (MavenBuild)m.getNearestOldBuild(end); b != null && b.getNumber() >= this.number; b = (MavenBuild)b.getPreviousBuild()) {
                Action a = b.getAction(action);
                if (a == null) continue;
                r.add(a);
                continue block0;
            }
        }
        return r;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl());
        ((MavenModuleSet)this.getProject()).updateTransientActions();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (List<MavenBuild> builds : this.getModuleBuilds().values()) {
            for (MavenBuild b : builds) {
                rs.add(b.getDownstreamRelationship(that));
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyModuleBuild(MavenBuild newBuild) {
        try {
            this.getParent().updateNextBuildNumber();
            Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
            MavenModuleSetBuild mavenModuleSetBuild = this;
            synchronized (mavenModuleSetBuild) {
                MavenAggregatedReport mar;
                boolean modified = false;
                List actions = this.getActions();
                HashSet individuals = new HashSet();
                for (Action a : actions) {
                    if (!(a instanceof MavenAggregatedReport)) continue;
                    mar = (MavenAggregatedReport)a;
                    mar.update(moduleBuilds, newBuild);
                    individuals.add(mar.getIndividualActionType());
                    modified = true;
                }
                for (AggregatableAction aa : newBuild.getActions(AggregatableAction.class)) {
                    if (!individuals.add(aa.getClass())) continue;
                    mar = aa.createAggregatedAction(this, moduleBuilds);
                    mar.update(moduleBuilds, newBuild);
                    actions.add(mar);
                    modified = true;
                }
                if (modified) {
                    this.save();
                    ((MavenModuleSet)this.getProject()).updateTransientActions();
                }
            }
            String moduleFsName = ((MavenModule)newBuild.getProject()).getModuleName().toFileSystemName();
            Util.createSymlink((File)this.getRootDir(), (String)("../../modules/" + moduleFsName + "/builds/" + newBuild.getId()), (String)moduleFsName, (TaskListener)StreamTaskListener.NULL);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
    }

    public MavenModuleSet getParent() {
        return (MavenModuleSet)super.getParent();
    }

    public static class SimpleTransferListener
    implements TransferListener {
        private TaskListener taskListener;

        public SimpleTransferListener(TaskListener taskListener) {
            this.taskListener = taskListener;
        }

        public void transferCorrupted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferFailed(TransferEvent transferEvent) {
            this.taskListener.getLogger().println("failed to transfer " + transferEvent.getException().getMessage());
        }

        public void transferInitiated(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferProgressed(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferStarted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferSucceeded(TransferEvent transferEvent) {
            this.taskListener.getLogger().println("downloaded artifact " + transferEvent.getResource().getRepositoryUrl() + "/" + transferEvent.getResource().getResourceName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PomParser
    implements FilePath.FileCallable<List<PomInfo>> {
        private final BuildListener listener;
        private final String rootPOM;
        private final boolean verbose = debug;
        private final Maven.MavenInstallation mavenHome;
        private final String profiles;
        private final Properties properties;
        private final String privateRepository;
        private final String alternateSettings;
        private final boolean nonRecursive;
        private final String workspaceProper;
        private final String mavenVersion;
        private final String moduleRootPath;
        private boolean resolveDependencies = false;
        private boolean processPlugins = false;
        private int mavenValidationLevel = -1;
        String rootPOMRelPrefix;
        private static final long serialVersionUID = 1L;

        public PomParser(BuildListener listener, Maven.MavenInstallation mavenHome, MavenModuleSet project, String mavenVersion) {
            this.listener = listener;
            this.mavenHome = mavenHome;
            this.rootPOM = project.getRootPOM();
            this.profiles = project.getProfiles();
            this.properties = project.getMavenProperties();
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (parametersDefinitionProperty != null && parametersDefinitionProperty.getParameterDefinitions() != null) {
                for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition)) continue;
                    this.properties.put("env." + parameterDefinition.getName(), ((StringParameterDefinition)parameterDefinition).getDefaultValue());
                }
            }
            this.nonRecursive = project.isNonRecursive();
            this.workspaceProper = ((MavenModuleSetBuild)project.getLastBuild()).getWorkspace().getRemote();
            this.privateRepository = project.usesPrivateRepository() ? ((MavenModuleSetBuild)project.getLastBuild()).getWorkspace().child(".repository").getRemote() : null;
            this.alternateSettings = project.getAlternateSettings();
            this.mavenVersion = mavenVersion;
            this.resolveDependencies = project.isResolveDependencies();
            this.processPlugins = project.isProcessPlugins();
            this.moduleRootPath = project.getScm().getModuleRoot(((MavenModuleSetBuild)project.getLastBuild()).getWorkspace(), (AbstractBuild)project.getLastBuild()).getRemote();
            this.mavenValidationLevel = project.getMavenValidationLevel();
        }

        public List<PomInfo> invoke(File ws, VirtualChannel channel) throws IOException {
            File settingsLoc;
            File wsp;
            File pom;
            PrintStream logger = this.listener.getLogger();
            if (IOUtils.isAbsolute((String)this.rootPOM)) {
                pom = new File(this.rootPOM);
            } else {
                pom = new File(ws, this.rootPOM);
                File parentLoc = new File(ws.getParentFile(), this.rootPOM);
                if (!pom.exists() && parentLoc.exists()) {
                    pom = parentLoc;
                }
            }
            if (!pom.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchPOMFile(pom));
            }
            this.rootPOMRelPrefix = this.rootPOM.startsWith("../") || this.rootPOM.startsWith("..\\") ? (!ws.equals(wsp = new File(this.workspaceProper)) ? ws.getCanonicalPath().substring(wsp.getCanonicalPath().length() + 1) + "/" : wsp.getName() + "/") : "";
            if (this.verbose) {
                logger.println("Parsing " + (this.nonRecursive ? "non-recursively " : "recursively ") + pom);
            }
            if (this.alternateSettings == null) {
                settingsLoc = null;
            } else if (IOUtils.isAbsolute((String)this.alternateSettings)) {
                settingsLoc = new File(this.alternateSettings);
            } else {
                settingsLoc = new File(this.workspaceProper, this.alternateSettings);
                File mrSettingsLoc = new File(this.workspaceProper, this.alternateSettings);
                if (!settingsLoc.exists() && mrSettingsLoc.exists()) {
                    settingsLoc = mrSettingsLoc;
                }
            }
            if (debug) {
                logger.println("use settingsLoc " + settingsLoc + " , privateRepository " + this.privateRepository);
            }
            if (settingsLoc != null && !settingsLoc.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchAlternateSettings(settingsLoc.getAbsolutePath()));
            }
            try {
                boolean maven3OrLater;
                MavenEmbedderRequest mavenEmbedderRequest = new MavenEmbedderRequest((TaskListener)this.listener, this.mavenHome.getHomeDir(), this.profiles, this.properties, this.privateRepository, settingsLoc);
                mavenEmbedderRequest.setTransferListener(new SimpleTransferListener((TaskListener)this.listener));
                mavenEmbedderRequest.setProcessPlugins(this.processPlugins);
                mavenEmbedderRequest.setResolveDependencies(this.resolveDependencies);
                ReactorReader reactorReader = null;
                boolean bl = maven3OrLater = new ComparableVersion(this.mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
                if (maven3OrLater) {
                    mavenEmbedderRequest.setValidationLevel(30);
                } else {
                    reactorReader = new ReactorReader(new HashMap(), new File(this.workspaceProper));
                    mavenEmbedderRequest.setWorkspaceReader((WorkspaceReader)reactorReader);
                }
                if (this.mavenValidationLevel >= 0) {
                    mavenEmbedderRequest.setValidationLevel(this.mavenValidationLevel);
                }
                MavenEmbedder embedder = MavenUtil.createEmbedder(mavenEmbedderRequest);
                MavenProject rootProject = null;
                List<MavenProject> mps = new ArrayList<MavenProject>(0);
                if (maven3OrLater) {
                    mps = embedder.readProjects(pom, !this.nonRecursive);
                } else {
                    MavenProject mavenProject;
                    rootProject = mavenProject = embedder.readProject(pom);
                    mps.add(mavenProject);
                    reactorReader.addProject(mavenProject);
                    if (!this.nonRecursive) {
                        this.readChilds(mavenProject, embedder, mps, reactorReader);
                    }
                }
                HashMap<String, MavenProject> canonicalPaths = new HashMap<String, MavenProject>(mps.size());
                for (MavenProject mavenProject : mps) {
                    canonicalPaths.put(mavenProject.getFile().getCanonicalPath(), mavenProject);
                }
                if (this.verbose) {
                    for (Map.Entry entry : canonicalPaths.entrySet()) {
                        logger.printf("Discovered %s at %s\n", ((MavenProject)entry.getValue()).getId(), entry.getKey());
                    }
                }
                LinkedHashSet<PomInfo> infos = new LinkedHashSet<PomInfo>();
                if (maven3OrLater) {
                    for (MavenProject mp : mps) {
                        if (!mp.isExecutionRoot()) continue;
                        rootProject = mp;
                    }
                }
                if (rootProject == null) {
                    rootProject = mps.get(0);
                }
                this.toPomInfo(rootProject, null, canonicalPaths, infos);
                for (PomInfo pi : infos) {
                    pi.cutCycle();
                }
                return new ArrayList<PomInfo>(infos);
            }
            catch (MavenEmbedderException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
        }

        private void toPomInfo(MavenProject mp, PomInfo parent, Map<String, MavenProject> abslPath, Set<PomInfo> infos) throws IOException {
            String relPath = PathTool.getRelativeFilePath((String)this.moduleRootPath, (String)mp.getBasedir().getPath());
            relPath = FilenameUtils.normalize((String)relPath);
            if (parent == null) {
                relPath = this.getRootPath(this.rootPOMRelPrefix);
            }
            relPath = StringUtils.removeStart((String)relPath, (String)"/");
            PomInfo pi = new PomInfo(mp, parent, relPath);
            infos.add(pi);
            if (!this.nonRecursive) {
                for (String modulePath : mp.getModules()) {
                    MavenProject child;
                    if (StringUtils.isBlank((String)modulePath)) continue;
                    File path = new File(mp.getBasedir(), modulePath);
                    if (path.isDirectory()) {
                        path = new File(mp.getBasedir(), modulePath + "/pom.xml");
                    }
                    if ((child = abslPath.get(path.getCanonicalPath())) == null) {
                        this.listener.getLogger().printf("Found a module with path " + modulePath + " but no associated project", new Object[0]);
                        continue;
                    }
                    this.toPomInfo(child, pi, abslPath, infos);
                }
            }
        }

        private void readChilds(MavenProject mp, MavenEmbedder mavenEmbedder, List<MavenProject> mavenProjects, ReactorReader reactorReader) throws ProjectBuildingException, MavenEmbedderException {
            if (mp.getModules() == null || mp.getModules().isEmpty()) {
                return;
            }
            for (String module : mp.getModules()) {
                if (Util.fixEmptyAndTrim((String)module) == null) continue;
                File pomFile = new File(mp.getFile().getParent(), module);
                MavenProject mavenProject2 = null;
                mavenProject2 = pomFile.isFile() && pomFile.exists() ? mavenEmbedder.readProject(pomFile) : mavenEmbedder.readProject(new File(mp.getFile().getParent(), module + "/pom.xml"));
                mavenProjects.add(mavenProject2);
                reactorReader.addProject(mavenProject2);
                this.readChilds(mavenProject2, mavenEmbedder, mavenProjects, reactorReader);
            }
        }

        private String getRootPath(String prefix) {
            int idx = Math.max(this.rootPOM.lastIndexOf(47), this.rootPOM.lastIndexOf(92));
            if (idx == -1) {
                return "";
            }
            return prefix + this.rootPOM.substring(0, idx);
        }
    }

    private static final class MavenExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MavenExecutionException(Exception cause) {
            super(cause);
        }

        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Builder
    extends MavenBuilder {
        private final Map<ModuleName, MavenBuildProxy2> proxies;
        private final Map<ModuleName, List<MavenReporter>> reporters = new HashMap<ModuleName, List<MavenReporter>>();
        private final Map<ModuleName, List<ExecutedMojo>> executedMojos = new HashMap<ModuleName, List<ExecutedMojo>>();
        private long mojoStartTime;
        private MavenBuildProxy2 lastProxy;
        private final transient Map<ModuleName, MavenBuild.ProxyImpl2> sourceProxies;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, Map<ModuleName, MavenBuild.ProxyImpl2> proxies, Collection<MavenModule> modules, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
            super(listener, goals, systemProps);
            this.sourceProxies = proxies;
            this.proxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>(proxies);
            for (Map.Entry<ModuleName, MavenBuildProxy2> e : this.proxies.entrySet()) {
                e.setValue(new FilterImpl(e.getValue(), mavenBuildInformation));
            }
            for (MavenModule m : modules) {
                this.reporters.put(m.getModuleName(), m.createReporters());
            }
        }

        void end(Launcher launcher) throws IOException, InterruptedException {
            for (Map.Entry<ModuleName, MavenBuild.ProxyImpl2> e : this.sourceProxies.entrySet()) {
                MavenBuild.ProxyImpl2 p = e.getValue();
                for (MavenReporter r : this.reporters.get(e.getKey())) {
                    r.end(p.owner(), launcher, this.listener);
                    p.appendLastLog();
                }
                p.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result call() throws IOException {
            try {
                if (debug) {
                    this.listener.getLogger().println("Builder extends MavenBuilder in call " + Thread.currentThread().getContextClassLoader());
                }
                Result result = super.call();
                return result;
            }
            finally {
                if (this.lastProxy != null) {
                    this.lastProxy.appendLastLog();
                }
            }
        }

        @Override
        void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            List projects = rm.getSortedProjects();
            HashSet<ModuleName> buildingProjects = new HashSet<ModuleName>();
            for (MavenProject mavenProject : projects) {
                buildingProjects.add(new ModuleName(mavenProject));
            }
            for (Map.Entry entry : this.proxies.entrySet()) {
                if (buildingProjects.contains(entry.getKey())) continue;
                MavenBuildProxy2 proxy = (MavenBuildProxy2)entry.getValue();
                proxy.start();
                proxy.setResult(Result.NOT_BUILT);
                proxy.end();
            }
        }

        @Override
        void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
        }

        @Override
        void preModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            ModuleName name = new ModuleName(project);
            MavenBuildProxy2 proxy = this.proxies.get(name);
            this.listener.getLogger().flush();
            proxy.start();
            for (MavenReporter r : this.reporters.get(name)) {
                if (r.preBuild(proxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        void postModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            ModuleName name = new ModuleName(project);
            MavenBuildProxy2 proxy = this.proxies.get(name);
            List<MavenReporter> rs = this.reporters.get(name);
            if (rs == null) {
                throw new AssertionError((Object)("reporters.get(" + name + ")==null. reporters=" + this.reporters + " proxies=" + this.proxies));
            }
            for (MavenReporter r : rs) {
                if (r.postBuild(proxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
            proxy.setExecutedMojos(this.executedMojos.get(name));
            this.listener.getLogger().flush();
            proxy.end();
            this.lastProxy = proxy;
        }

        @Override
        void preExecute(MavenProject project, MojoInfo mojoInfo) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            ModuleName name = new ModuleName(project);
            MavenBuildProxy proxy = this.proxies.get(name);
            for (MavenReporter r : this.reporters.get(name)) {
                if (r.preExecute(proxy, project, mojoInfo, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
            this.mojoStartTime = System.currentTimeMillis();
        }

        @Override
        void postExecute(MavenProject project, MojoInfo mojoInfo, Exception exception) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            ModuleName name = new ModuleName(project);
            List<ExecutedMojo> mojoList = this.executedMojos.get(name);
            if (mojoList == null) {
                mojoList = new ArrayList<ExecutedMojo>();
                this.executedMojos.put(name, mojoList);
            }
            mojoList.add(new ExecutedMojo(mojoInfo, System.currentTimeMillis() - this.mojoStartTime));
            MavenBuildProxy2 proxy = this.proxies.get(name);
            for (MavenReporter r : this.reporters.get(name)) {
                if (r.postExecute(proxy, project, mojoInfo, this.listener, exception)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
            if (exception != null) {
                proxy.setResult(Result.FAILURE);
            }
        }

        @Override
        void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            ModuleName name = new ModuleName(project);
            MavenBuildProxy proxy = this.proxies.get(name);
            for (MavenReporter r : this.reporters.get(name)) {
                if (r.reportGenerated(proxy, project, report, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        public ClassLoader getClassLoader() {
            return new MaskingClassLoader(super.getClassLoader(), new String[0]);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FilterImpl
        extends MavenBuildProxy2.Filter<MavenBuildProxy2>
        implements Serializable {
            private MavenBuildInformation mavenBuildInformation;
            private static final long serialVersionUID = 1L;

            public FilterImpl(MavenBuildProxy2 core, MavenBuildInformation mavenBuildInformation) {
                super(core);
                this.mavenBuildInformation = mavenBuildInformation;
            }

            @Override
            public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.futures.add(Channel.current().callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }

            @Override
            public MavenBuildInformation getMavenBuildInformation() {
                return this.mavenBuildInformation;
            }
        }
    }

    private class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        private Map<ModuleName, MavenBuild.ProxyImpl2> proxies;

        private RunnerImpl() {
            super((AbstractBuild)MavenModuleSetBuild.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Result doRun(BuildListener listener) throws Exception {
            PrintStream logger = listener.getLogger();
            Result r = null;
            try {
                Result result;
                boolean maven2_1orLater;
                EnvVars envVars = MavenModuleSetBuild.this.getEnvironment((TaskListener)listener);
                Maven.MavenInstallation mvn = ((MavenModuleSet)MavenModuleSetBuild.this.project).getMaven();
                if (mvn == null) {
                    throw new AbortException("A Maven installation needs to be available for this project to be built.\nEither your server has no Maven installations defined, or the requested Maven version does not exist.");
                }
                mvn = mvn.forEnvironment(envVars).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                MavenInformation mavenInformation = (MavenInformation)MavenModuleSetBuild.this.getModuleRoot().act((Callable)new MavenVersionCallable(mvn.getHome()));
                String mavenVersion = mavenInformation.getVersion();
                MavenBuildInformation mavenBuildInformation = new MavenBuildInformation(mavenVersion);
                MavenModuleSetBuild.this.setMavenVersionUsed(mavenVersion);
                listener.getLogger().println("Found mavenVersion " + mavenVersion + " from file " + mavenInformation.getVersionResourcePath());
                if (!((MavenModuleSet)MavenModuleSetBuild.this.project).isAggregatorStyleBuild()) {
                    this.parsePoms(listener, logger, envVars, mvn, mavenVersion);
                    logger.println("Triggering " + ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule().getModuleName());
                    ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule().scheduleBuild((Cause)new Cause.UpstreamCause((Run)MavenModuleSetBuild.this));
                    return r;
                }
                ArrayList<BuildWrapper> wrappers = new ArrayList<BuildWrapper>();
                for (BuildWrapper w : ((MavenModuleSet)MavenModuleSetBuild.this.project).getBuildWrappersList()) {
                    wrappers.add(w);
                }
                ParametersAction parameters = (ParametersAction)MavenModuleSetBuild.this.getAction(ParametersAction.class);
                if (parameters != null) {
                    parameters.createBuildWrappers((AbstractBuild)MavenModuleSetBuild.this, wrappers);
                }
                for (BuildWrapper w : wrappers) {
                    BuildWrapper.Environment e = w.setUp((AbstractBuild)MavenModuleSetBuild.this, this.launcher, listener);
                    if (e == null) {
                        Result result2 = r = Result.FAILURE;
                        return result2;
                    }
                    MavenModuleSetBuild.this.buildEnvironments.add(e);
                    e.buildEnvVars((Map)envVars);
                }
                if (!this.preBuild(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers())) {
                    Result i$ = Result.FAILURE;
                    return i$;
                }
                this.parsePoms(listener, logger, envVars, mvn, mavenVersion);
                SplittableBuildListener slistener = new SplittableBuildListener(listener);
                this.proxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>();
                ArrayList<String> changedModules = new ArrayList<String>();
                for (MavenModule m : ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules) {
                    MavenBuild mb = m.newBuild();
                    mb.setBuiltOnStr(MavenModuleSetBuild.this.getBuiltOnStr());
                    if (!MavenModuleSetBuild.this.getChangeSet().isEmptySet() && ((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild() && (mb.getPreviousBuiltBuild() == null || !MavenModuleSetBuild.this.getChangeSetFor(m).isEmpty() || ((MavenBuild)mb.getPreviousBuiltBuild()).getResult().isWorseThan(Result.SUCCESS))) {
                        changedModules.add(m.getModuleName().toString());
                    }
                    mb.setWorkspace(MavenModuleSetBuild.this.getModuleRoot().child(m.getRelativePath()));
                    ModuleName moduleName = m.getModuleName();
                    MavenBuild mavenBuild = mb;
                    ((Object)((Object)mavenBuild)).getClass();
                    this.proxies.put(moduleName, mavenBuild.new MavenBuild.ProxyImpl2(MavenModuleSetBuild.this, slistener));
                }
                String rootPOM = ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootPOM();
                FilePath pom = MavenModuleSetBuild.this.getModuleRoot().child(rootPOM);
                FilePath parentLoc = MavenModuleSetBuild.this.getWorkspace().child(rootPOM);
                if (!pom.exists() && parentLoc.exists()) {
                    pom = parentLoc;
                }
                ProcessCache.MavenProcess process = null;
                boolean maven3orLater = MavenUtil.maven3orLater(mavenVersion);
                if (maven3orLater) {
                    LOGGER.info("using maven 3 " + mavenVersion);
                    process = MavenBuild.mavenProcessCache.get(this.launcher.getChannel(), slistener, new Maven3ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, this.launcher, envVars, pom.getParent()));
                } else {
                    process = MavenBuild.mavenProcessCache.get(this.launcher.getChannel(), slistener, new MavenProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, this.launcher, envVars, pom.getParent()));
                }
                ArgumentListBuilder margs = new ArgumentListBuilder().add("-B").add(new String[]{"-f", pom.getRemote()});
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).usesPrivateRepository()) {
                    margs.add("-Dmaven.repo.local=" + MavenModuleSetBuild.this.getWorkspace().child(".repository"));
                }
                boolean bl = maven2_1orLater = new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("2.1")) >= 0;
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild() && maven2_1orLater && !changedModules.isEmpty()) {
                    margs.add("-amd");
                    margs.add(new String[]{"-pl", Util.join(changedModules, (String)",")});
                }
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).getAlternateSettings() != null) {
                    if (IOUtils.isAbsolute((String)((MavenModuleSet)MavenModuleSetBuild.this.project).getAlternateSettings())) {
                        margs.add("-s").add(((MavenModuleSet)MavenModuleSetBuild.this.project).getAlternateSettings());
                    } else {
                        FilePath mrSettings = MavenModuleSetBuild.this.getModuleRoot().child(((MavenModuleSet)MavenModuleSetBuild.this.project).getAlternateSettings());
                        FilePath wsSettings = MavenModuleSetBuild.this.getWorkspace().child(((MavenModuleSet)MavenModuleSetBuild.this.project).getAlternateSettings());
                        if (!wsSettings.exists() && mrSettings.exists()) {
                            wsSettings = mrSettings;
                        }
                        margs.add("-s").add(wsSettings.getRemote());
                    }
                }
                margs.addTokenized(envVars.expand(((MavenModuleSet)MavenModuleSetBuild.this.project).getGoals()));
                if (maven3orLater) {
                    HashMap<ModuleName, List<MavenReporter>> reporters = new HashMap<ModuleName, List<MavenReporter>>(((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules.size());
                    for (MavenModule mavenModule : ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules) {
                        reporters.put(mavenModule.getModuleName(), mavenModule.createReporters());
                    }
                    Maven3Builder maven3Builder = new Maven3Builder(slistener, this.proxies, reporters, margs.toList(), (Map<String, String>)envVars, mavenBuildInformation);
                    MavenProbeAction mpa = null;
                    try {
                        mpa = new MavenProbeAction((AbstractProject)MavenModuleSetBuild.this.project, process.channel);
                        MavenModuleSetBuild.this.addAction(mpa);
                        Result result3 = r = (Result)process.call(maven3Builder);
                        return result3;
                    }
                    finally {
                        maven3Builder.end(this.launcher);
                        MavenModuleSetBuild.this.getActions().remove(mpa);
                        process.discard();
                    }
                }
                Builder builder = new Builder(slistener, this.proxies, ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules, margs.toList(), (Map<String, String>)envVars, mavenBuildInformation);
                MavenProbeAction mpa = null;
                try {
                    mpa = new MavenProbeAction((AbstractProject)MavenModuleSetBuild.this.project, process.channel);
                    MavenModuleSetBuild.this.addAction(mpa);
                    result = r = (Result)process.call(builder);
                }
                catch (Throwable throwable) {
                    try {
                        builder.end(this.launcher);
                        MavenModuleSetBuild.this.getActions().remove(mpa);
                        process.discard();
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        r = Result.ABORTED;
                        throw e;
                    }
                }
                builder.end(this.launcher);
                MavenModuleSetBuild.this.getActions().remove(mpa);
                process.discard();
                return result;
                finally {
                    if (r != null) {
                        MavenModuleSetBuild.this.setResult(r);
                    }
                    boolean failed = false;
                    for (int i = MavenModuleSetBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                        if (((Environment)MavenModuleSetBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)MavenModuleSetBuild.this, listener)) continue;
                        failed = true;
                    }
                    if (failed) {
                        return Result.FAILURE;
                    }
                }
            }
            catch (AbortException e) {
                if (e.getMessage() == null) return Result.FAILURE;
                listener.error(e.getMessage());
                return Result.FAILURE;
            }
            catch (InterruptedIOException e) {
                e.printStackTrace(listener.error("Aborted Maven execution for InterruptedIOException"));
                return Result.ABORTED;
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(Messages.MavenModuleSetBuild_FailedToParsePom()));
                return Result.FAILURE;
            }
            catch (Run.RunnerAbortedException e) {
                return Result.FAILURE;
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error("Processing failed due to a bug in the code. Please report this to jenkins-users@googlegroups.com"));
                logger.println("project=" + MavenModuleSetBuild.this.project);
                logger.println("project.getModules()=" + ((MavenModuleSet)MavenModuleSetBuild.this.project).getModules());
                logger.println("project.getRootModule()=" + (Object)((Object)((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule()));
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePoms(BuildListener listener, PrintStream logger, EnvVars envVars, Maven.MavenInstallation mvn, String mavenVersion) throws IOException, InterruptedException {
            Map<ModuleName, MavenModule> modules;
            List poms;
            logger.println("Parsing POMs");
            try {
                poms = (List)MavenModuleSetBuild.this.getModuleRoot().act((FilePath.FileCallable)new PomParser(listener, mvn, (MavenModuleSet)MavenModuleSetBuild.this.project, mavenVersion));
            }
            catch (IOException e) {
                if (e.getCause() instanceof AbortException) {
                    throw (AbortException)e.getCause();
                }
                throw e;
            }
            catch (MavenExecutionException e) {
                e.getCause().printStackTrace(listener.error(Messages.MavenModuleSetBuild_FailedToParsePom()));
                throw new AbortException();
            }
            Map<ModuleName, MavenModule> map = modules = ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).modules;
            synchronized (map) {
                HashMap<ModuleName, MavenModule> old = new HashMap<ModuleName, MavenModule>(modules);
                ArrayList<MavenModule> sortedModules = new ArrayList<MavenModule>();
                modules.clear();
                if (debug) {
                    logger.println("Root POM is " + ((PomInfo)poms.get((int)0)).name);
                }
                ((MavenModuleSet)MavenModuleSetBuild.this.project).reconfigure((PomInfo)poms.get(0));
                for (PomInfo pom : poms) {
                    MavenModule mm = (MavenModule)((Object)old.get(pom.name));
                    if (mm != null) {
                        if (debug) {
                            logger.println("Reconfiguring " + (Object)((Object)mm));
                        }
                        mm.reconfigure(pom);
                        modules.put(pom.name, mm);
                    } else {
                        logger.println(Messages.MavenModuleSetBuild_DiscoveredModule(pom.name, pom.displayName));
                        mm = new MavenModule((MavenModuleSet)MavenModuleSetBuild.this.project, pom, MavenModuleSetBuild.this.getNumber());
                        modules.put(mm.getModuleName(), mm);
                    }
                    sortedModules.add(mm);
                    mm.save();
                }
                ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules = sortedModules;
                old.keySet().removeAll(modules.keySet());
                for (MavenModule om : old.values()) {
                    if (debug) {
                        logger.println("Disabling " + (Object)((Object)om));
                    }
                    om.makeDisabled(true);
                }
                modules.putAll(old);
            }
            Hudson.getInstance().rebuildDependencyGraph();
            for (MavenModule m : modules.values()) {
                m.updateNextBuildNumber(MavenModuleSetBuild.this.getNumber());
            }
        }

        protected void post2(BuildListener listener) throws Exception {
            for (MavenBuild b : MavenModuleSetBuild.this.getModuleLastBuilds().values()) {
                b.save();
            }
            if (!this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            if (!this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            MavenFingerprinter.aggregate(MavenModuleSetBuild.this);
        }

        public void cleanUp(BuildListener listener) throws Exception {
            MavenMailer mailer = (MavenMailer)((MavenModuleSet)MavenModuleSetBuild.this.project).getReporters().get(MavenMailer.class);
            if (mailer != null) {
                new MailSender(mailer.recipients, mailer.dontNotifyEveryUnstableBuild, mailer.sendToIndividuals).execute((AbstractBuild)MavenModuleSetBuild.this, listener);
            }
            this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), false);
            this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), false);
            super.cleanUp(listener);
        }
    }
}

