/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Hudson;
import hudson.tasks.Fingerprinter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenFingerprinter
extends MavenReporter {
    private transient Set<File> files;
    private transient Map<String, String> used;
    private transient Map<String, String> produced;
    private static final long serialVersionUID = 1L;

    @Override
    public boolean preBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        this.files = new HashSet<File>();
        this.used = new HashMap<String, String>();
        this.produced = new HashMap<String, String>();
        return true;
    }

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        this.record(pom.getArtifacts(), this.used);
        this.record(pom.getArtifact(), this.produced);
        this.record(pom.getAttachedArtifacts(), this.produced);
        this.record(pom.getGroupId(), pom.getFile(), this.produced);
        return true;
    }

    @Override
    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        build.executeAsync(new MavenBuildProxy.BuildCallable<Void, IOException>(){
            private final Map<String, String> u;
            private final Map<String, String> p;
            {
                this.u = MavenFingerprinter.this.used;
                this.p = MavenFingerprinter.this.produced;
            }

            @Override
            public Void call(MavenBuild build) throws IOException, InterruptedException {
                FingerprintMap map = Hudson.getInstance().getFingerprintMap();
                for (Map.Entry<String, String> e : this.p.entrySet()) {
                    map.getOrCreate((AbstractBuild)build, e.getKey(), e.getValue()).add((AbstractBuild)build);
                }
                for (Map.Entry<String, String> e : this.u.entrySet()) {
                    map.getOrCreate(null, e.getKey(), e.getValue()).add((AbstractBuild)build);
                }
                HashMap<String, String> all = new HashMap<String, String>(this.u);
                all.putAll(this.p);
                Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)build.getAction(Fingerprinter.FingerprintAction.class);
                if (fa != null) {
                    fa.add(all);
                } else {
                    build.getActions().add(new Fingerprinter.FingerprintAction((AbstractBuild)build, all));
                }
                return null;
            }
        });
        return true;
    }

    private void record(Collection<Artifact> artifacts, Map<String, String> record) throws IOException, InterruptedException {
        for (Artifact a : artifacts) {
            this.record(a, record);
        }
    }

    private void record(Artifact a, Map<String, String> record) throws IOException, InterruptedException {
        File f = a.getFile();
        if (this.files == null) {
            throw new InternalError();
        }
        this.record(a.getGroupId(), f, record);
    }

    private void record(String groupId, File f, Map<String, String> record) throws IOException, InterruptedException {
        if (f == null || !f.exists() || f.isDirectory() || !this.files.add(f)) {
            return;
        }
        String digest = new FilePath(f).digest();
        record.put(groupId + ':' + f.getName(), digest);
    }

    public static void aggregate(MavenModuleSetBuild mmsb) throws IOException {
        HashMap records = new HashMap();
        for (List<MavenBuild> builds : mmsb.getModuleBuilds().values()) {
            for (MavenBuild build : builds) {
                Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)build.getAction(Fingerprinter.FingerprintAction.class);
                if (fa == null) continue;
                records.putAll(fa.getRecords());
            }
        }
        if (!records.isEmpty()) {
            FingerprintMap map = Hudson.getInstance().getFingerprintMap();
            for (Map.Entry e : records.entrySet()) {
                map.getOrCreate(null, (String)e.getKey(), (String)e.getValue()).add((AbstractBuild)mmsb);
            }
            mmsb.addAction((Action)new Fingerprinter.FingerprintAction((AbstractBuild)mmsb, records));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenFingerprinter_DisplayName();
        }

        public MavenReporter newAutoInstance(MavenModule module) {
            return new MavenFingerprinter();
        }
    }
}

