/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.JavadocArchiver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenJavadocArchiver
extends MavenReporter {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File destDir;
        boolean aggregated;
        if (!mojo.is("org.apache.maven.plugins", "maven-javadoc-plugin", "javadoc") && !mojo.is("org.apache.maven.plugins", "maven-javadoc-plugin", "aggregate")) {
            return true;
        }
        try {
            boolean bl = aggregated = mojo.getConfigurationValue("aggregate", Boolean.class) != false || mojo.getGoal().equals("aggregate");
            if (aggregated && !pom.isExecutionRoot()) {
                return true;
            }
            destDir = mojo.getConfigurationValue("reportOutputDirectory", File.class);
            if (destDir == null) {
                destDir = mojo.getConfigurationValue("outputDirectory", File.class);
            }
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_NoDestDir()));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (destDir.exists()) {
            FilePath target;
            if (aggregated) {
                listener.getLogger().println("[JENKINS] Archiving aggregated javadoc");
                target = build.getModuleSetRootDir();
            } else {
                listener.getLogger().println("[JENKINS] Archiving javadoc");
                target = build.getProjectRootDir();
            }
            target = target.child("javadoc");
            try {
                new FilePath(destDir).copyRecursiveTo("**/*", target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_FailedToCopy(destDir, target)));
                build.setResult(Result.FAILURE);
            }
            if (aggregated) {
                build.registerAsAggregatedProjectAction(this);
            } else {
                build.registerAsProjectAction(this);
            }
        }
        return true;
    }

    @Override
    public boolean reportGenerated(MavenBuildProxy build, MavenProject pom, MavenReportInfo report, BuildListener listener) throws InterruptedException, IOException {
        return this.postExecute(build, pom, report, listener, null);
    }

    @Override
    public Collection<? extends Action> getProjectActions(MavenModule project) {
        return Collections.singleton(new JavadocArchiver.JavadocAction((AbstractItem)project));
    }

    @Override
    public Action getAggregatedProjectAction(MavenModuleSet project) {
        return new JavadocArchiver.JavadocAction((AbstractItem)project);
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenJavadocArchiver_DisplayName();
        }

        public MavenJavadocArchiver newAutoInstance(MavenModule module) {
            return new MavenJavadocArchiver();
        }
    }
}

