/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.Util;
import hudson.maven.Maven3Builder;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.maven.reporters.SurefireReport;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireArchiver
extends MavenReporter {
    private TestResult result;
    private static final long serialVersionUID = 1L;

    @Override
    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        XmlPlexusConfiguration c;
        if (this.isSurefireTest(mojo) && !mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test") && (c = (XmlPlexusConfiguration)mojo.configuration.getChild("testFailureIgnore")) != null && c.getValue().equals("${maven.test.failure.ignore}") && System.getProperty("maven.test.failure.ignore") == null) {
            if (this.maven3orLater(build.getMavenBuildInformation().getMavenVersion())) {
                String fieldName = "testFailureIgnore";
                if (mojo.mojoExecution.getConfiguration().getChild(fieldName) != null) {
                    mojo.mojoExecution.getConfiguration().getChild(fieldName).setValue(Boolean.TRUE.toString());
                } else {
                    Xpp3Dom child = new Xpp3Dom(fieldName);
                    child.setValue(Boolean.TRUE.toString());
                    mojo.mojoExecution.getConfiguration().addChild(child);
                }
            } else {
                c.setValue(Boolean.TRUE.toString());
            }
        }
        return true;
    }

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, final BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File reportsDir;
        if (!this.isSurefireTest(mojo)) {
            return true;
        }
        listener.getLogger().println(Messages.SurefireArchiver_Recording());
        if (mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test") || mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test")) {
            try {
                reportsDir = mojo.getConfigurationValue("reportsDirectory", File.class);
            }
            catch (ComponentConfigurationException e) {
                e.printStackTrace(listener.fatalError(Messages.SurefireArchiver_NoReportsDir()));
                build.setResult(Result.FAILURE);
                return true;
            }
        } else {
            reportsDir = new File(pom.getBasedir(), "target/surefire-reports");
        }
        if (reportsDir.exists()) {
            FileSet fs = Util.createFileSet((File)reportsDir, (String)"*.xml", (String)"testng-results.xml,testng-failed.xml");
            DirectoryScanner ds = fs.getDirectoryScanner();
            if (ds.getIncludedFiles().length == 0) {
                return true;
            }
            if (this.result == null) {
                this.result = new TestResult();
            }
            this.result.parse(System.currentTimeMillis() - build.getMilliSecsSinceBuildStart(), ds);
            int failCount = build.execute(new MavenBuildProxy.BuildCallable<Integer, IOException>(){

                @Override
                public Integer call(MavenBuild build) throws IOException, InterruptedException {
                    SurefireReport sr = (SurefireReport)build.getAction(SurefireReport.class);
                    if (sr == null) {
                        build.getActions().add(new SurefireReport(build, SurefireArchiver.this.result, listener));
                    } else {
                        sr.setResult(SurefireArchiver.this.result, listener);
                    }
                    if (SurefireArchiver.this.result.getFailCount() > 0) {
                        build.setResult(Result.UNSTABLE);
                    }
                    build.registerAsProjectAction(new FactoryImpl());
                    return SurefireArchiver.this.result.getFailCount();
                }
            });
            if (failCount > 0 && error instanceof MojoFailureException) {
                MavenBuilder.markAsSuccess = true;
            }
            if (failCount > 0) {
                Maven3Builder.markAsSuccess = true;
            }
        }
        return true;
    }

    public static void fixUp(List<MavenProjectActionBuilder> builders) {
        if (builders == null) {
            return;
        }
        ListIterator<MavenProjectActionBuilder> itr = builders.listIterator();
        while (itr.hasNext()) {
            MavenProjectActionBuilder b = itr.next();
            if (!(b instanceof SurefireArchiver)) continue;
            itr.set(new FactoryImpl());
        }
    }

    private boolean isSurefireTest(MojoInfo mojo) {
        if (!(mojo.is("com.sun.maven", "maven-junit-plugin", "test") || mojo.is("org.sonatype.flexmojos", "flexmojos-maven-plugin", "test-run") || mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test") || mojo.is("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test"))) {
            return false;
        }
        try {
            Boolean skipTests;
            if (mojo.is("org.apache.maven.plugins", "maven-surefire-plugin", "test")) {
                Boolean skipTests2;
                Boolean skipExec;
                Boolean skip = mojo.getConfigurationValue("skip", Boolean.class);
                if (skip != null && skip.booleanValue()) {
                    return false;
                }
                if (mojo.pluginName.version.compareTo("2.3") >= 0 && (skipExec = mojo.getConfigurationValue("skipExec", Boolean.class)) != null && skipExec.booleanValue()) {
                    return false;
                }
                if (mojo.pluginName.version.compareTo("2.4") >= 0 && (skipTests2 = mojo.getConfigurationValue("skipTests", Boolean.class)) != null && skipTests2.booleanValue()) {
                    return false;
                }
            } else if (mojo.is("com.sun.maven", "maven-junit-plugin", "test") ? (skipTests = mojo.getConfigurationValue("skipTests", Boolean.class)) != null && skipTests != false : mojo.is("org.sonatype.flexmojos", "flexmojos-maven-plugin", "test-run") && (skipTests = mojo.getConfigurationValue("skipTest", Boolean.class)) != null && skipTests != false) {
                return false;
            }
        }
        catch (ComponentConfigurationException e) {
            return false;
        }
        return true;
    }

    public boolean maven3orLater(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return false;
        }
        return new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.SurefireArchiver_DisplayName();
        }

        public SurefireArchiver newAutoInstance(MavenModule module) {
            return new SurefireArchiver();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FactoryImpl
    implements MavenProjectActionBuilder {
        FactoryImpl() {
        }

        @Override
        public Collection<? extends Action> getProjectActions(MavenModule module) {
            return Collections.singleton(new TestResultProjectAction((AbstractProject)module));
        }
    }
}

