/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.ProcessCache;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.tasks.Maven;
import hudson.tasks._maven.MavenConsoleAnnotator;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.kohsuke.stapler.framework.io.IOException2;

public abstract class AbstractMavenProcessFactory {
    private final MavenModuleSet mms;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final FilePath workDir;
    private final String mavenOpts;
    public static boolean mavenRemoteUseInet = Boolean.getBoolean("maven.remote.useinet");
    public static final String MAVEN_REMOTE_USEINET_ENV_VAR_NAME = "MAVEN_REMOTE_USEINET";

    AbstractMavenProcessFactory(MavenModuleSet mms, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        this.mms = mms;
        this.launcher = launcher;
        this.envVars = envVars;
        this.workDir = workDir;
        this.mavenOpts = mavenOpts;
    }

    public ProcessCache.NewProcess newProcess(BuildListener listener, OutputStream out) throws IOException, InterruptedException {
        if (MavenProcessFactory.debug) {
            listener.getLogger().println("Using env variables: " + this.envVars);
        }
        try {
            Connection con;
            Charset charset;
            Acceptor acceptor = (Acceptor)this.launcher.getChannel().call((Callable)new SocketHandler());
            try {
                charset = Charset.forName((String)this.launcher.getChannel().call((Callable)new GetCharset()));
            }
            catch (UnsupportedCharsetException e) {
                charset = Charset.forName("iso-8859-1");
            }
            MavenConsoleAnnotator mca = new MavenConsoleAnnotator(out, charset);
            if (mavenRemoteUseInet) {
                this.envVars.put(MAVEN_REMOTE_USEINET_ENV_VAR_NAME, "true");
            }
            ArgumentListBuilder cmdLine = this.buildMavenAgentCmdLine(listener, acceptor.getPort());
            Object[] cmds = cmdLine.toCommandArray();
            Proc proc = this.launcher.launch().cmds((String[])cmds).envs((Map)this.envVars).stdout((OutputStream)mca).pwd(this.workDir).start();
            try {
                con = acceptor.accept();
            }
            catch (SocketTimeoutException e) {
                if (!proc.isAlive()) {
                    throw new AbortException("Failed to launch Maven. Exit code = " + proc.join());
                }
                throw e;
            }
            return new ProcessCache.NewProcess(Channels.forProcess((String)("Channel to Maven " + Arrays.toString(cmds)), (ExecutorService)Computer.threadPoolForRemoting, (InputStream)new BufferedInputStream(con.in), (OutputStream)new BufferedOutputStream(con.out), (OutputStream)listener.getLogger(), (Proc)proc), proc);
        }
        catch (IOException e) {
            JDK jdk;
            if (Util.fixNull((String)e.getMessage()).contains("java: not found") && (jdk = this.mms.getJDK()) == null) {
                throw new IOException2(this.mms.getDisplayName() + " is not configured with a JDK, but your PATH doesn't include Java", (Throwable)e);
            }
            throw e;
        }
    }

    protected abstract ArgumentListBuilder buildMavenAgentCmdLine(BuildListener var1, int var2) throws IOException, InterruptedException;

    public String getMavenOpts() {
        Node n;
        if (this.mavenOpts != null) {
            return this.mavenOpts;
        }
        String mavenOpts = this.mms.getMavenOpts();
        if ((mavenOpts == null || mavenOpts.trim().length() == 0) && (n = this.getCurrentNode()) != null) {
            try {
                String localMavenOpts = (String)n.toComputer().getEnvironment().get((Object)"MAVEN_OPTS");
                if (localMavenOpts != null && localMavenOpts.trim().length() > 0) {
                    mavenOpts = localMavenOpts;
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.envVars.expand(mavenOpts);
    }

    public Maven.MavenInstallation getMavenInstallation(TaskListener log) throws IOException, InterruptedException {
        Maven.MavenInstallation mi = this.mms.getMaven();
        if (mi != null) {
            mi = mi.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return mi;
    }

    public JDK getJava(TaskListener log) throws IOException, InterruptedException {
        JDK jdk = this.mms.getJDK();
        if (jdk != null) {
            jdk = jdk.forNode(this.getCurrentNode(), log).forEnvironment(this.envVars);
        }
        return jdk;
    }

    protected Node getCurrentNode() {
        return Executor.currentExecutor().getOwner().getNode();
    }

    protected MavenModuleSet getMavenModuleSet() {
        return this.mms;
    }

    protected Launcher getLauncher() {
        return this.launcher;
    }

    protected EnvVars getEnvVars() {
        return this.envVars;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class GetRemotingJar
    implements Callable<String, IOException> {
        protected GetRemotingJar() {
        }

        public String call() throws IOException {
            return Which.jarFile(hudson.remoting.Launcher.class).getPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetCharset
    implements Callable<String, IOException> {
        private GetCharset() {
        }

        public String call() throws IOException {
            return System.getProperty("file.encoding");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SocketHandler
    implements Callable<Acceptor, IOException> {
        private static final long serialVersionUID = 1L;

        private SocketHandler() {
        }

        public Acceptor call() throws IOException {
            return new AcceptorImpl();
        }

        static final class AcceptorImpl
        implements Acceptor,
        Serializable {
            private final transient ServerSocket serverSocket = new ServerSocket();
            private transient Socket socket;

            AcceptorImpl() throws IOException {
                this.serverSocket.bind(null);
                this.serverSocket.setSoTimeout(MavenProcessFactory.socketTimeOut);
            }

            public Connection accept() throws IOException {
                this.socket = this.serverSocket.accept();
                this.serverSocket.close();
                return new Connection((InputStream)new SocketInputStream(this.socket), (OutputStream)new SocketOutputStream(this.socket));
            }

            public int getPort() {
                return this.serverSocket.getLocalPort();
            }

            private Object writeReplace() {
                return Channel.current().export(Acceptor.class, (Object)this);
            }
        }
    }

    static interface Acceptor {
        public Connection accept() throws IOException;

        public int getPort();
    }

    private static final class Connection
    implements Serializable {
        public InputStream in;
        public OutputStream out;
        private static final long serialVersionUID = 1L;

        Connection(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        private Object writeReplace() {
            return new Connection((InputStream)new RemoteInputStream(this.in), (OutputStream)new RemoteOutputStream(this.out));
        }

        private Object readResolve() {
            this.in = new BufferedInputStream(this.in);
            this.out = new BufferedOutputStream(this.out);
            return this;
        }
    }
}

