/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Maven;
import hudson.triggers.Trigger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenProject<P extends AbstractProject<P, R>, R extends AbstractBuild<P, R>>
extends AbstractProject<P, R>
implements Maven.ProjectWithMaven {
    protected AbstractMavenProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected List<Action> createTransientActions() {
        List r = super.createTransientActions();
        HashSet<Class> added = new HashSet<Class>();
        this.addTransientActionsFromBuild((AbstractBuild)this.getLastBuild(), r, added);
        this.addTransientActionsFromBuild((AbstractBuild)this.getLastSuccessfulBuild(), r, added);
        for (Trigger trigger : this.triggers) {
            r.addAll(trigger.getProjectActions());
        }
        return r;
    }

    protected abstract void addTransientActionsFromBuild(R var1, List<Action> var2, Set<Class> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MavenModuleDependency
    extends DependencyGraph.Dependency {
        public MavenModuleDependency(AbstractMavenProject<?, ?> upstream, AbstractProject<?, ?> downstream) {
            super(upstream, downstream);
        }

        public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                return false;
            }
            AbstractProject downstreamProject = this.getDownstreamProject();
            if (AbstractMavenBuild.debug) {
                listener.getLogger().println("Considering whether to trigger " + downstreamProject + " or not");
            }
            boolean trigger = true;
            AbstractMavenProject parent = (AbstractMavenProject)this.getUpstreamProject();
            if (this.areUpstreamsBuilding(downstreamProject, parent)) {
                if (AbstractMavenBuild.debug) {
                    listener.getLogger().println(" -> No, because downstream has dependencies already building or in queue");
                }
                trigger = false;
            } else if (this.inDownstreamProjects(downstreamProject)) {
                if (AbstractMavenBuild.debug) {
                    listener.getLogger().println(" -> No, because downstream has dependencies in the downstream projects list");
                }
                trigger = false;
            } else {
                AbstractBuild dlb = (AbstractBuild)downstreamProject.getLastBuild();
                for (AbstractMavenProject up : Util.filter((List)downstreamProject.getUpstreamProjects(), AbstractMavenProject.class)) {
                    int n;
                    Object ulb = up == parent ? (build.getResult() == null || !build.getResult().isWorseThan(Result.UNSTABLE) ? build : up.getLastSuccessfulBuild()) : up.getLastSuccessfulBuild();
                    if (ulb == null) {
                        if (AbstractMavenBuild.debug) {
                            listener.getLogger().println(" -> No, because another upstream " + (Object)((Object)up) + " for " + downstreamProject + " has no successful build");
                        }
                        trigger = false;
                        break;
                    }
                    if (dlb != null && (n = dlb.getUpstreamRelationship((AbstractProject)up)) != -1) assert (ulb.getNumber() >= n);
                }
            }
            return trigger;
        }

        private boolean areUpstreamsBuilding(AbstractProject<?, ?> downstreamProject, AbstractProject<?, ?> excludeProject) {
            DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
            Set tups = graph.getTransitiveUpstream(downstreamProject);
            for (AbstractProject tup : tups) {
                if (tup == excludeProject || !tup.isBuilding() && !tup.isInQueue()) continue;
                return true;
            }
            return false;
        }

        private boolean inDownstreamProjects(AbstractProject<?, ?> downstreamProject) {
            DependencyGraph graph = Hudson.getInstance().getDependencyGraph();
            Set tups = graph.getTransitiveUpstream(downstreamProject);
            for (AbstractProject tup : tups) {
                List downstreamProjects = this.getUpstreamProject().getDownstreamProjects();
                for (AbstractProject dp : downstreamProjects) {
                    if (dp == this.getUpstreamProject() || dp == downstreamProject || dp != tup) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

