/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Launcher;
import hudson.maven.AbstractMavenBuilder;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReporter;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.util.ExecutionEventLogger;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.maven.cli.PrintStreamLogger;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven3Builder
extends AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private final boolean profile = MavenProcessFactory.profile;
    protected transient List<Future<?>> futures;
    HudsonMavenExecutionResult mavenExecutionResult;
    private final Map<ModuleName, MavenBuildProxy2> proxies;
    private final Map<ModuleName, MavenBuild.ProxyImpl2> sourceProxies;
    private final Map<ModuleName, List<MavenReporter>> reporters = new HashMap<ModuleName, List<MavenReporter>>();
    private final MavenBuildInformation mavenBuildInformation;
    public static boolean markAsSuccess;
    private static final long serialVersionUID = 1L;

    protected Maven3Builder(BuildListener listener, Map<ModuleName, MavenBuild.ProxyImpl2> proxies, Map<ModuleName, List<MavenReporter>> reporters, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
        super(listener, goals, systemProps);
        this.mavenBuildInformation = mavenBuildInformation;
        this.sourceProxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>(proxies);
        this.proxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>(proxies);
        for (Map.Entry<ModuleName, MavenBuildProxy2> e : this.proxies.entrySet()) {
            e.setValue(new FilterImpl(e.getValue(), this.mavenBuildInformation, Channel.current()));
        }
        this.reporters.putAll(reporters);
    }

    public Result call() throws IOException {
        MavenExecutionListener mavenExecutionListener = new MavenExecutionListener(this);
        try {
            this.futures = new CopyOnWriteArrayList();
            Maven3Launcher.setMavenExecutionListener((ExecutionListener)mavenExecutionListener);
            markAsSuccess = false;
            for (Map.Entry e : this.systemProps.entrySet()) {
                if (e.getValue() == null) {
                    throw new IllegalArgumentException("System property " + (String)e.getKey() + " has a null value");
                }
                System.getProperties().put(e.getKey(), e.getValue());
            }
            this.listener.getLogger().println(this.formatArgs(this.goals));
            int r = Maven3Main.launch((String[])this.goals.toArray(new String[this.goals.size()]));
            boolean messageReported = false;
            long startTime = System.nanoTime();
            for (Future<?> f : this.futures) {
                try {
                    if (!f.isDone() && !messageReported) {
                        messageReported = true;
                        this.listener.getLogger().println("maven builder waiting");
                    }
                    f.get();
                }
                catch (InterruptedException e) {
                    for (Future<?> g : this.futures) {
                        g.cancel(true);
                    }
                    this.listener.getLogger().println("build aborted");
                    return Result.ABORTED;
                }
                catch (ExecutionException e) {
                    e.printStackTrace(this.listener.error("async build failed"));
                }
            }
            mavenExecutionListener.overheadTime += System.nanoTime() - startTime;
            this.futures.clear();
            if (this.profile) {
                NumberFormat n = NumberFormat.getInstance();
                PrintStream logger = this.listener.getLogger();
                logger.println("Total overhead was " + this.format(n, mavenExecutionListener.overheadTime) + "ms");
                Channel ch = Channel.current();
                logger.println("Class loading " + this.format(n, ch.classLoadingTime.get()) + "ms, " + ch.classLoadingCount + " classes");
                logger.println("Resource loading " + this.format(n, ch.resourceLoadingTime.get()) + "ms, " + ch.resourceLoadingCount + " times");
            }
            this.mavenExecutionResult = Maven3Launcher.getMavenExecutionResult();
            PrintStream logger = this.listener.getLogger();
            if (r == 0 && this.mavenExecutionResult.getThrowables().isEmpty()) {
                return Result.SUCCESS;
            }
            if (!this.mavenExecutionResult.getThrowables().isEmpty()) {
                logger.println("mavenExecutionResult exceptions not empty");
                for (Throwable throwable : this.mavenExecutionResult.getThrowables()) {
                    throwable.printStackTrace(logger);
                }
            }
            if (markAsSuccess) {
                this.listener.getLogger().println(Messages.MavenBuilder_Failed());
                return Result.SUCCESS;
            }
            return Result.FAILURE;
        }
        catch (NoSuchMethodException e) {
            throw new IOException2((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IOException2((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new IOException2((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException2((Throwable)e);
        }
        catch (Exception e) {
            throw new IOException2((Throwable)e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return Hudson.getInstance().getPluginManager().uberClassLoader;
    }

    void end(Launcher launcher) throws IOException, InterruptedException {
        for (Map.Entry<ModuleName, MavenBuild.ProxyImpl2> e : this.sourceProxies.entrySet()) {
            MavenBuild.ProxyImpl2 p = e.getValue();
            for (MavenReporter r : this.reporters.get(e.getKey())) {
                r.end(p.owner(), launcher, this.listener);
                p.appendLastLog();
            }
            p.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MavenExecutionListener
    extends AbstractExecutionListener
    implements Serializable,
    ExecutionListener {
        private final Maven3Builder maven3Builder;
        long overheadTime;
        private final Map<ModuleName, MavenBuildProxy2> proxies;
        private final Map<ModuleName, List<ExecutedMojo>> executedMojosPerModule = new ConcurrentHashMap<ModuleName, List<ExecutedMojo>>();
        private final Map<ModuleName, List<MavenReporter>> reporters = new ConcurrentHashMap<ModuleName, List<MavenReporter>>();
        private final Map<ModuleName, Long> currentMojoStartPerModuleName = new ConcurrentHashMap<ModuleName, Long>();
        private ExecutionEventLogger eventLogger;

        public MavenExecutionListener(Maven3Builder maven3Builder) {
            this.maven3Builder = maven3Builder;
            this.proxies = new ConcurrentHashMap<ModuleName, MavenBuildProxy2>(maven3Builder.proxies);
            for (Map.Entry<ModuleName, MavenBuildProxy2> e : this.proxies.entrySet()) {
                Maven3Builder maven3Builder2 = maven3Builder;
                maven3Builder2.getClass();
                e.setValue(maven3Builder2.new FilterImpl(e.getValue(), maven3Builder.mavenBuildInformation, Channel.current()));
                this.executedMojosPerModule.put(e.getKey(), new CopyOnWriteArrayList());
            }
            this.reporters.putAll(new ConcurrentHashMap(maven3Builder.reporters));
            this.eventLogger = new ExecutionEventLogger((Logger)new PrintStreamLogger(maven3Builder.listener.getLogger()));
        }

        private MavenBuildProxy2 getMavenBuildProxy2(MavenProject mavenProject) {
            for (Map.Entry<ModuleName, MavenBuildProxy2> entry : this.proxies.entrySet()) {
                if (entry.getKey().compareTo(new ModuleName(mavenProject)) != 0) continue;
                return entry.getValue();
            }
            return null;
        }

        private Mojo getMojo(MojoExecution mojoExecution, MavenSession mavenSession) {
            return null;
        }

        private ExpressionEvaluator getExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
            return new PluginParameterExpressionEvaluator(session, mojoExecution);
        }

        private List<MavenReporter> getMavenReporters(MavenProject mavenProject) {
            return this.reporters.get(new ModuleName(mavenProject));
        }

        private void initMojoStartTime(MavenProject mavenProject) {
            this.currentMojoStartPerModuleName.put(new ModuleName(mavenProject.getGroupId(), mavenProject.getArtifactId()), new Date().getTime());
        }

        private Long getMojoStartTime(MavenProject mavenProject) {
            return this.currentMojoStartPerModuleName.get(new ModuleName(mavenProject.getGroupId(), mavenProject.getArtifactId()));
        }

        public void projectDiscoveryStarted(ExecutionEvent event) {
            this.eventLogger.projectDiscoveryStarted(event);
        }

        public void sessionStarted(ExecutionEvent event) {
            this.eventLogger.sessionStarted(event);
            List projects = event.getSession().getProjects();
            HashSet<ModuleName> buildingProjects = new HashSet<ModuleName>();
            for (MavenProject mavenProject : projects) {
                buildingProjects.add(new ModuleName(mavenProject));
            }
            for (Map.Entry entry : this.proxies.entrySet()) {
                if (buildingProjects.contains(entry.getKey())) continue;
                MavenBuildProxy2 proxy = (MavenBuildProxy2)entry.getValue();
                proxy.start();
                proxy.setResult(Result.NOT_BUILT);
                proxy.end();
            }
        }

        public void sessionEnded(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("sessionEnded");
            this.eventLogger.sessionEnded(event);
        }

        public void projectSkipped(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("projectSkipped " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.eventLogger.projectSkipped(event);
        }

        public void projectStarted(ExecutionEvent event) {
            this.reccordProjectStarted(event);
            this.eventLogger.projectStarted(event);
        }

        public void reccordProjectStarted(ExecutionEvent event) {
            MavenProject mavenProject = event.getProject();
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.start();
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.enterModule(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.preBuild(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void projectSucceeded(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("projectSucceeded " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.reccordProjectSucceeded(event);
            this.eventLogger.projectSucceeded(event);
        }

        public void reccordProjectSucceeded(ExecutionEvent event) {
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(event.getProject());
            mavenBuildProxy2.end();
            mavenBuildProxy2.setResult(Result.SUCCESS);
            List<MavenReporter> mavenReporters = this.getMavenReporters(event.getProject());
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.leaveModule(mavenBuildProxy2, event.getProject(), this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postBuild(mavenBuildProxy2, event.getProject(), this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void projectFailed(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("projectFailed " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.reccordProjectFailed(event);
            this.eventLogger.projectFailed(event);
        }

        public void reccordProjectFailed(ExecutionEvent event) {
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(event.getProject());
            mavenBuildProxy2.end();
            mavenBuildProxy2.setResult(Result.FAILURE);
            MavenProject mavenProject = event.getProject();
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.leaveModule(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postBuild(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void mojoSkipped(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("mojoSkipped " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.eventLogger.mojoSkipped(event);
        }

        public void mojoStarted(ExecutionEvent event) {
            this.reccordMojoStarted(event);
            this.eventLogger.mojoStarted(event);
        }

        public void reccordMojoStarted(ExecutionEvent event) {
            this.initMojoStartTime(event.getProject());
            MavenProject mavenProject = event.getProject();
            XmlPlexusConfiguration xmlPlexusConfiguration = new XmlPlexusConfiguration(event.getMojoExecution().getConfiguration());
            Mojo mojo = null;
            MojoInfo mojoInfo = new MojoInfo(event.getMojoExecution(), mojo, (PlexusConfiguration)xmlPlexusConfiguration, this.getExpressionEvaluator(event.getSession(), event.getMojoExecution()));
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.preExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void mojoSucceeded(ExecutionEvent event) {
            this.reccordMojoSucceeded(event);
            this.eventLogger.mojoSucceeded(event);
        }

        public void reccordMojoSucceeded(ExecutionEvent event) {
            Long startTime = this.getMojoStartTime(event.getProject());
            Date endTime = new Date();
            MavenProject mavenProject = event.getProject();
            XmlPlexusConfiguration xmlPlexusConfiguration = new XmlPlexusConfiguration(event.getMojoExecution().getConfiguration());
            Mojo mojo = null;
            MojoInfo mojoInfo = new MojoInfo(event.getMojoExecution(), mojo, (PlexusConfiguration)xmlPlexusConfiguration, this.getExpressionEvaluator(event.getSession(), event.getMojoExecution()));
            try {
                ExecutedMojo executedMojo = new ExecutedMojo(mojoInfo, startTime == null ? 0L : endTime.getTime() - startTime);
                this.executedMojosPerModule.get(new ModuleName(mavenProject.getGroupId(), mavenProject.getArtifactId())).add(executedMojo);
            }
            catch (Exception e) {
                this.maven3Builder.listener.getLogger().println("ignoring exception during new ExecutedMojo " + e.getMessage());
            }
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.setExecutedMojos(this.executedMojosPerModule.get(new ModuleName(event.getProject())));
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, null);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void mojoFailed(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("mojoFailed " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.reccordMojoFailed(event);
            this.eventLogger.mojoFailed(event);
        }

        public void reccordMojoFailed(ExecutionEvent event) {
            Long startTime = this.getMojoStartTime(event.getProject());
            Date endTime = new Date();
            MavenProject mavenProject = event.getProject();
            XmlPlexusConfiguration xmlPlexusConfiguration = new XmlPlexusConfiguration(event.getMojoExecution().getConfiguration());
            Mojo mojo = null;
            MojoInfo mojoInfo = new MojoInfo(event.getMojoExecution(), mojo, (PlexusConfiguration)xmlPlexusConfiguration, this.getExpressionEvaluator(event.getSession(), event.getMojoExecution()));
            try {
                ExecutedMojo executedMojo = new ExecutedMojo(mojoInfo, startTime == null ? 0L : endTime.getTime() - startTime);
                this.executedMojosPerModule.get(new ModuleName(mavenProject.getGroupId(), mavenProject.getArtifactId())).add(executedMojo);
            }
            catch (Exception e) {
                this.maven3Builder.listener.getLogger().println("ignoring exception during new ExecutedMojo " + e.getMessage());
            }
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            mavenBuildProxy2.setExecutedMojos(this.executedMojosPerModule.get(new ModuleName(event.getProject())));
            if (mavenReporters != null) {
                for (MavenReporter mavenReporter : mavenReporters) {
                    try {
                        try {
                            mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, event.getException());
                        }
                        catch (NoSuchMethodError e) {
                            mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, null);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void forkStarted(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("mojo forkStarted " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.reccordMojoStarted(event);
        }

        public void forkSucceeded(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("mojo forkSucceeded " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.reccordMojoSucceeded(event);
        }

        public void forkFailed(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("mojo forkFailed " + event.getMojoExecution().getGroupId() + ":" + event.getMojoExecution().getArtifactId() + ":" + event.getMojoExecution().getVersion() + "(" + event.getMojoExecution().getExecutionId() + ")");
            this.reccordMojoFailed(event);
        }

        public void forkedProjectStarted(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("forkedProjectStarted " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + event.getProject().getVersion());
            this.reccordProjectStarted(event);
            this.eventLogger.forkedProjectStarted(event);
        }

        public void forkedProjectSucceeded(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("forkedProjectSucceeded " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + event.getProject().getVersion());
            this.reccordProjectSucceeded(event);
            this.eventLogger.forkedProjectSucceeded(event);
        }

        public void forkedProjectFailed(ExecutionEvent event) {
            this.maven3Builder.listener.getLogger().println("forkedProjectFailed " + event.getProject().getGroupId() + ":" + event.getProject().getArtifactId() + ":" + event.getProject().getVersion());
            this.reccordProjectFailed(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterImpl
    extends MavenBuildProxy2.Filter<MavenBuildProxy2>
    implements Serializable {
        private MavenBuildInformation mavenBuildInformation;
        private Channel channel;
        private static final long serialVersionUID = 1L;

        public FilterImpl(MavenBuildProxy2 core, MavenBuildInformation mavenBuildInformation, Channel channel) {
            super(core);
            this.mavenBuildInformation = mavenBuildInformation;
            this.channel = channel;
        }

        @Override
        public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            Maven3Builder.this.futures.add(this.channel.callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return this.mavenBuildInformation;
        }
    }
}

