/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.ProcessCache;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Which;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;

public class Maven3ProcessFactory
extends AbstractMavenProcessFactory
implements ProcessCache.Factory {
    private static final FilenameFilter CLASSWORLDS_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.contains("plexus-classworlds") && name.endsWith(".jar");
        }
    };

    Maven3ProcessFactory(MavenModuleSet mms, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        super(mms, launcher, envVars, mavenOpts, workDir);
    }

    protected ArgumentListBuilder buildMavenAgentCmdLine(BuildListener listener, int tcpPort) throws IOException, InterruptedException {
        Maven.MavenInstallation mvn = this.getMavenInstallation((TaskListener)listener);
        if (mvn == null) {
            listener.error("Maven version is not configured for this project. Can't determine which Maven to run");
            throw new Run.RunnerAbortedException();
        }
        if (mvn.getHome() == null) {
            listener.error("Maven '%s' doesn't have its home set", new Object[]{mvn.getName()});
            throw new Run.RunnerAbortedException();
        }
        String classWorldsJar = (String)this.getLauncher().getChannel().call((Callable)new GetClassWorldsJar(mvn.getHome(), (TaskListener)listener));
        boolean isMaster = this.getCurrentNode() == Hudson.getInstance();
        FilePath slaveRoot = null;
        if (!isMaster) {
            slaveRoot = this.getCurrentNode().getRootPath();
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        JDK jdk = this.getJava((TaskListener)listener);
        if (jdk == null) {
            args.add("java");
        } else {
            args.add(jdk.getHome() + "/bin/java");
        }
        if (MavenProcessFactory.debugPort != 0) {
            args.add("-Xrunjdwp:transport=dt_socket,server=y,address=" + MavenProcessFactory.debugPort);
        }
        if (MavenProcessFactory.yjp) {
            args.add("-agentlib:yjpagent=tracing");
        }
        args.addTokenized(this.getMavenOpts());
        args.add("-cp");
        args.add((isMaster ? Which.jarFile(Maven3Main.class).getAbsolutePath() : slaveRoot.child("maven3-agent.jar").getRemote()) + (this.getLauncher().isUnix() ? ":" : ";") + classWorldsJar);
        args.add(Maven3Main.class.getName());
        args.add(mvn.getHome());
        String remotingJar = (String)this.getLauncher().getChannel().call((Callable)new AbstractMavenProcessFactory.GetRemotingJar());
        if (remotingJar == null) {
            listener.error("Failed to determine the location of slave.jar");
            throw new Run.RunnerAbortedException();
        }
        args.add(remotingJar);
        args.add(isMaster ? Which.jarFile(Maven3Launcher.class).getAbsolutePath() : slaveRoot.child("maven3-interceptor.jar").getRemote());
        args.add((Object)tcpPort);
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetClassWorldsJar
    implements Callable<String, IOException> {
        private final String mvnHome;
        private final TaskListener listener;

        private GetClassWorldsJar(String mvnHome, TaskListener listener) {
            this.mvnHome = mvnHome;
            this.listener = listener;
        }

        public String call() throws IOException {
            File bootDir;
            File[] classworlds;
            File home = new File(this.mvnHome);
            if (MavenProcessFactory.debug) {
                this.listener.getLogger().println("Using mvnHome: " + this.mvnHome);
            }
            if (!((classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) != null && classworlds.length != 0 || (classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) != null && classworlds.length != 0)) {
                this.listener.error("classworld not found");
                throw new Run.RunnerAbortedException();
            }
            return classworlds[0].getAbsolutePath();
        }
    }
}

