/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.AbstractMavenBuilder;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReportInfo;
import hudson.maven.Messages;
import hudson.maven.MojoInfo;
import hudson.maven.agent.AbortException;
import hudson.maven.agent.Main;
import hudson.maven.agent.PluginManagerListener;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutorListener;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenBuilder
extends AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private final boolean profile = MavenProcessFactory.profile;
    protected transient List<Future<?>> futures;
    private Class<?> pluginManagerInterceptorClazz;
    private Class<?> lifecycleInterceptorClazz;
    public static boolean markAsSuccess;
    private static final long serialVersionUID = 1L;

    protected MavenBuilder(BuildListener listener, List<String> goals, Map<String, String> systemProps) {
        super(listener, goals, systemProps);
    }

    abstract void preBuild(MavenSession var1, ReactorManager var2, EventDispatcher var3) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException;

    abstract void postBuild(MavenSession var1, ReactorManager var2, EventDispatcher var3) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException;

    abstract void preModule(MavenProject var1) throws InterruptedException, IOException, AbortException;

    abstract void postModule(MavenProject var1) throws InterruptedException, IOException, AbortException;

    abstract void preExecute(MavenProject var1, MojoInfo var2) throws IOException, InterruptedException, AbortException;

    abstract void postExecute(MavenProject var1, MojoInfo var2, Exception var3) throws IOException, InterruptedException, AbortException;

    abstract void onReportGenerated(MavenProject var1, MavenReportInfo var2) throws IOException, InterruptedException, AbortException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result call() throws IOException {
        int r;
        Adapter a;
        ClassLoader mavenJailProcessClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.futures = new ArrayList();
            a = new Adapter(this);
            this.callSetListenerWithReflectOnInterceptors(a, mavenJailProcessClassLoader);
            markAsSuccess = false;
            for (Map.Entry e : this.systemProps.entrySet()) {
                if (e.getValue() == null) {
                    throw new IllegalArgumentException("System property " + (String)e.getKey() + " has a null value");
                }
                System.getProperties().put(e.getKey(), e.getValue());
            }
            this.listener.getLogger().println(this.formatArgs(this.goals));
            r = Main.launch((String[])this.goals.toArray(new String[this.goals.size()]));
            boolean messageReported = false;
            long startTime = System.nanoTime();
            for (Future<?> f : this.futures) {
                try {
                    if (!f.isDone() && !messageReported) {
                        messageReported = true;
                        this.listener.getLogger().println(Messages.MavenBuilder_Waiting());
                    }
                    f.get();
                }
                catch (InterruptedException e) {
                    Iterator<Future<?>> i$ = this.futures.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            this.listener.getLogger().println(Messages.MavenBuilder_Aborted());
                            Result result = Result.ABORTED;
                            this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
                            return result;
                        }
                        Future<?> g = i$.next();
                        g.cancel(true);
                    }
                }
                catch (ExecutionException e) {
                    e.printStackTrace(this.listener.error(Messages.MavenBuilder_AsyncFailed()));
                }
            }
            a.overheadTime += System.nanoTime() - startTime;
        }
        catch (NoSuchMethodException e) {
            throw new IOException2((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IOException2((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new IOException2((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new IOException2((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException2((Throwable)e);
        }
        catch (NoSuchRealmException e) {
            throw new IOException2((Throwable)e);
        }
        this.futures.clear();
        if (this.profile) {
            NumberFormat n = NumberFormat.getInstance();
            PrintStream logger = this.listener.getLogger();
            logger.println("Total overhead was " + this.format(n, a.overheadTime) + "ms");
            Channel ch = Channel.current();
            logger.println("Class loading " + this.format(n, ch.classLoadingTime.get()) + "ms, " + ch.classLoadingCount + " classes");
            logger.println("Resource loading " + this.format(n, ch.resourceLoadingTime.get()) + "ms, " + ch.resourceLoadingCount + " times");
        }
        if (r == 0) {
            return Result.SUCCESS;
        }
        if (!markAsSuccess) return Result.FAILURE;
        this.listener.getLogger().println(Messages.MavenBuilder_Failed());
        return Result.SUCCESS;
        finally {
            this.callSetListenerWithReflectOnInterceptorsQuietly(null, mavenJailProcessClassLoader);
        }
    }

    private void callSetListenerWithReflectOnInterceptors(PluginManagerListener pluginManagerListener, ClassLoader cl) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.pluginManagerInterceptorClazz == null) {
            this.pluginManagerInterceptorClazz = cl.loadClass("hudson.maven.agent.PluginManagerInterceptor");
        }
        Method setListenerMethod = this.pluginManagerInterceptorClazz.getMethod("setListener", cl.loadClass("hudson.maven.agent.PluginManagerListener"));
        setListenerMethod.invoke(null, pluginManagerListener);
        if (this.lifecycleInterceptorClazz == null) {
            this.lifecycleInterceptorClazz = cl.loadClass("org.apache.maven.lifecycle.LifecycleExecutorInterceptor");
        }
        setListenerMethod = this.lifecycleInterceptorClazz.getMethod("setListener", cl.loadClass("org.apache.maven.lifecycle.LifecycleExecutorListener"));
        setListenerMethod.invoke(null, pluginManagerListener);
    }

    private void callSetListenerWithReflectOnInterceptorsQuietly(PluginManagerListener pluginManagerListener, ClassLoader cl) {
        try {
            this.callSetListenerWithReflectOnInterceptors(pluginManagerListener, cl);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static final class Adapter
    implements PluginManagerListener,
    LifecycleExecutorListener {
        private MavenProject lastModule;
        private final MavenBuilder listener;
        long overheadTime;

        public Adapter(MavenBuilder listener) {
            this.listener = listener;
        }

        public void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.preBuild(session, rm, dispatcher);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.fireLeaveModule();
            this.listener.postBuild(session, rm, dispatcher);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void endModule() throws InterruptedException, IOException {
            long startTime = System.nanoTime();
            this.fireLeaveModule();
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void preExecute(MavenProject project, MojoExecution exec, Mojo mojo, PlexusConfiguration mergedConfig, ExpressionEvaluator eval) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            if (this.lastModule != project) {
                this.fireLeaveModule();
                this.fireEnterModule(project);
            }
            this.listener.preExecute(project, new MojoInfo(exec, mojo, mergedConfig, eval));
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void postExecute(MavenProject project, MojoExecution exec, Mojo mojo, PlexusConfiguration mergedConfig, ExpressionEvaluator eval, Exception exception) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.postExecute(project, new MojoInfo(exec, mojo, mergedConfig, eval), exception);
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void onReportGenerated(MavenReport report, MojoExecution mojoExecution, PlexusConfiguration mergedConfig, ExpressionEvaluator eval) throws IOException, InterruptedException {
            long startTime = System.nanoTime();
            this.listener.onReportGenerated(this.lastModule, new MavenReportInfo(mojoExecution, report, mergedConfig, eval));
            this.overheadTime += System.nanoTime() - startTime;
        }

        private void fireEnterModule(MavenProject project) throws InterruptedException, IOException {
            this.lastModule = project;
            this.listener.preModule(project);
        }

        private void fireLeaveModule() throws InterruptedException, IOException {
            if (this.lastModule != null) {
                this.listener.postModule(this.lastModule);
                this.lastModule = null;
            }
        }
    }
}

