/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenUtil;
import hudson.maven.Messages;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.Proxy;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedeployPublisher
extends Recorder {
    public final String id;
    public final String url;
    public final boolean uniqueVersion;
    public final boolean evenIfUnstable;

    public RedeployPublisher(String id, String url, boolean uniqueVersion) {
        this(id, url, uniqueVersion, false);
    }

    @DataBoundConstructor
    public RedeployPublisher(String id, String url, boolean uniqueVersion, boolean evenIfUnstable) {
        this.id = id;
        this.url = Util.fixEmptyAndTrim((String)url);
        this.uniqueVersion = uniqueVersion;
        this.evenIfUnstable = evenIfUnstable;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(this.getTreshold())) {
            return true;
        }
        if (this.url == null) {
            listener.getLogger().println("No Repository URL is specified.");
            build.setResult(Result.FAILURE);
            return true;
        }
        List<MavenAbstractArtifactRecord> mars = this.getActions(build, listener);
        if (mars == null || mars.isEmpty()) {
            listener.getLogger().println("No artifacts are recorded. Is this a Maven project?");
            build.setResult(Result.FAILURE);
            return true;
        }
        listener.getLogger().println("Deploying artifacts to " + this.url);
        try {
            MavenEmbedder embedder = this.createEmbedder((TaskListener)listener, build);
            ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.ROLE, "default");
            ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
            ArtifactRepository repository = factory.createDeploymentArtifactRepository(this.id, this.url, layout, this.uniqueVersion);
            WrappedArtifactRepository repo = new WrappedArtifactRepository(repository, this.uniqueVersion);
            for (MavenAbstractArtifactRecord mar : mars) {
                mar.deploy(embedder, repo, (TaskListener)listener);
            }
            return true;
        }
        catch (MavenEmbedderException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (ComponentLookupException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (ArtifactDeploymentException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        build.setResult(Result.FAILURE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenEmbedder createEmbedder(TaskListener listener, AbstractBuild<?, ?> build) throws MavenEmbedderException, IOException, InterruptedException {
        Object m = null;
        File settingsLoc = null;
        String profiles = null;
        Properties systemProperties = null;
        String privateRepository = null;
        File tmpSettings = File.createTempFile("jenkins", "temp-settings.xml");
        try {
            AbstractProject project = build.getProject();
            if (project instanceof MavenModuleSet) {
                profiles = ((MavenModuleSet)project).getProfiles();
                systemProperties = ((MavenModuleSet)project).getMavenProperties();
                String altSettingsPath = ((MavenModuleSet)project).getAlternateSettings();
                Node buildNode = build.getBuiltOn();
                if (buildNode == null) {
                    buildNode = Hudson.getInstance();
                }
                if (StringUtils.isBlank((String)altSettingsPath)) {
                    String remoteUserHome = (String)build.getWorkspace().act((Callable)new GetUserHome());
                    altSettingsPath = remoteUserHome + "/.m2/settings.xml";
                }
                FilePath filePath = new FilePath(tmpSettings);
                FilePath remoteSettings = build.getWorkspace().child(altSettingsPath);
                if (!remoteSettings.exists()) {
                    String mavenHome = ((MavenModuleSet)project).getMaven().forNode(buildNode, listener).getHome();
                    String settingsPath = mavenHome + "/conf/settings.xml";
                    remoteSettings = build.getWorkspace().child(settingsPath);
                }
                listener.getLogger().println("Maven RedeployPublished use remote " + (buildNode != null ? buildNode.getNodeName() : "local") + " maven settings from : " + remoteSettings.getRemote());
                remoteSettings.copyTo(filePath);
                settingsLoc = tmpSettings;
            }
            MavenEmbedder mavenEmbedder = MavenUtil.createEmbedder(new MavenEmbedderRequest(listener, m != null ? m.getHomeDir() : null, profiles, systemProperties, privateRepository, settingsLoc));
            return mavenEmbedder;
        }
        finally {
            tmpSettings.delete();
        }
    }

    protected MavenAbstractArtifactRecord getAction(AbstractBuild<?, ?> build) {
        return (MavenAbstractArtifactRecord)build.getAction(MavenAbstractArtifactRecord.class);
    }

    protected List<MavenAbstractArtifactRecord> getActions(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<MavenAbstractArtifactRecord> actions = new ArrayList<MavenAbstractArtifactRecord>();
        if (!(build instanceof MavenModuleSetBuild)) {
            return actions;
        }
        for (Map.Entry<MavenModule, MavenBuild> e : ((MavenModuleSetBuild)build).getModuleLastBuilds().entrySet()) {
            MavenAbstractArtifactRecord a = (MavenAbstractArtifactRecord)e.getValue().getAction(MavenAbstractArtifactRecord.class);
            if (a == null) {
                listener.getLogger().println("No artifacts are recorded for module" + e.getKey().getName() + ". Is this a Maven project?");
                continue;
            }
            actions.add(a);
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected Result getTreshold() {
        if (this.evenIfUnstable) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappedArtifactRepository
    implements ArtifactRepository {
        private ArtifactRepository artifactRepository;
        private boolean uniqueVersion;

        public WrappedArtifactRepository(ArtifactRepository artifactRepository, boolean uniqueVersion) {
            this.artifactRepository = artifactRepository;
            this.uniqueVersion = uniqueVersion;
        }

        public String pathOf(Artifact artifact) {
            return this.artifactRepository.pathOf(artifact);
        }

        public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
            return this.artifactRepository.pathOfRemoteRepositoryMetadata(artifactMetadata);
        }

        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.artifactRepository.pathOfLocalRepositoryMetadata(metadata, repository);
        }

        public String getUrl() {
            return this.artifactRepository.getUrl();
        }

        public void setUrl(String url) {
            this.artifactRepository.setUrl(url);
        }

        public String getBasedir() {
            return this.artifactRepository.getBasedir();
        }

        public String getProtocol() {
            return this.artifactRepository.getProtocol();
        }

        public String getId() {
            return this.artifactRepository.getId();
        }

        public void setId(String id) {
            this.artifactRepository.setId(id);
        }

        public ArtifactRepositoryPolicy getSnapshots() {
            return this.artifactRepository.getSnapshots();
        }

        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
            this.artifactRepository.setSnapshotUpdatePolicy(policy);
        }

        public ArtifactRepositoryPolicy getReleases() {
            return this.artifactRepository.getReleases();
        }

        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
            this.artifactRepository.setReleaseUpdatePolicy(policy);
        }

        public ArtifactRepositoryLayout getLayout() {
            return this.artifactRepository.getLayout();
        }

        public void setLayout(ArtifactRepositoryLayout layout) {
            this.artifactRepository.setLayout(layout);
        }

        public String getKey() {
            return this.artifactRepository.getKey();
        }

        public boolean isUniqueVersion() {
            return this.uniqueVersion;
        }

        public void setUniqueVersion(boolean uniqueVersion) {
            this.uniqueVersion = uniqueVersion;
        }

        public boolean isBlacklisted() {
            return this.artifactRepository.isBlacklisted();
        }

        public void setBlacklisted(boolean blackListed) {
            this.artifactRepository.setBlacklisted(blackListed);
        }

        public Artifact find(Artifact artifact) {
            return this.artifactRepository.find(artifact);
        }

        public List<String> findVersions(Artifact artifact) {
            return this.artifactRepository.findVersions(artifact);
        }

        public boolean isProjectAware() {
            return this.artifactRepository.isProjectAware();
        }

        public void setAuthentication(Authentication authentication) {
            this.artifactRepository.setAuthentication(authentication);
        }

        public Authentication getAuthentication() {
            return this.artifactRepository.getAuthentication();
        }

        public void setProxy(Proxy proxy) {
            this.artifactRepository.setProxy(proxy);
        }

        public Proxy getProxy() {
            return this.artifactRepository.getProxy();
        }

        public List<ArtifactRepository> getMirroredRepositories() {
            return Collections.emptyList();
        }

        public void setMirroredRepositories(List<ArtifactRepository> arg0) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
        }

        protected DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType == MavenModuleSet.class;
        }

        public RedeployPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (RedeployPublisher)((Object)req.bindJSON(RedeployPublisher.class, formData));
        }

        public String getDisplayName() {
            return Messages.RedeployPublisher_getDisplayName();
        }

        public boolean showEvenIfUnstableOption() {
            return true;
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            String fixedUrl = Util.fixEmptyAndTrim((String)url);
            if (fixedUrl == null) {
                return FormValidation.error((String)Messages.RedeployPublisher_RepositoryURL_Mandatory());
            }
            return FormValidation.ok();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetUserHome
    implements Callable<String, IOException> {
        private GetUserHome() {
        }

        public String call() throws IOException {
            return System.getProperty("user.home");
        }
    }
}

