/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.JavadocArchiver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenJavadocArchiver
extends MavenReporter {
    private boolean aggregated = false;
    private FilePath target;
    private static final long serialVersionUID = 1L;

    public abstract boolean checkIsJavadocMojo(MojoInfo var1);

    public abstract String getArchiveTargetPath();

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File destDir;
        if (!this.checkIsJavadocMojo(mojo)) {
            return true;
        }
        try {
            boolean bl = this.aggregated = mojo.getConfigurationValue("aggregate", Boolean.class) != false || mojo.getGoal().equals("aggregate") || mojo.getGoal().equals("test-aggregate");
            if (this.aggregated && !pom.isExecutionRoot()) {
                return true;
            }
            destDir = mojo.getConfigurationValue("reportOutputDirectory", File.class);
            if (destDir == null) {
                destDir = mojo.getConfigurationValue("outputDirectory", File.class);
            }
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_NoDestDir()));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (destDir.exists()) {
            if (this.aggregated) {
                listener.getLogger().println("[JENKINS] Archiving aggregated javadoc");
                this.target = build.getModuleSetRootDir();
            } else {
                listener.getLogger().println("[JENKINS] Archiving  javadoc");
                this.target = build.getProjectRootDir();
            }
            this.target = this.target.child(this.getArchiveTargetPath());
            try {
                new FilePath(destDir).copyRecursiveTo("**/*", this.target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_FailedToCopy(destDir, this.target)));
                build.setResult(Result.FAILURE);
            }
            if (this.aggregated) {
                build.registerAsAggregatedProjectAction(this);
            } else {
                build.registerAsProjectAction(this);
            }
            if (pom.getModules() != null && pom.getModules().isEmpty() && pom.isExecutionRoot()) {
                build.registerAsAggregatedProjectAction(this);
            }
        }
        return true;
    }

    @Override
    public boolean reportGenerated(MavenBuildProxy build, MavenProject pom, MavenReportInfo report, BuildListener listener) throws InterruptedException, IOException {
        return this.postExecute(build, pom, report, listener, null);
    }

    @Override
    public abstract Collection<? extends Action> getProjectActions(MavenModule var1);

    @Override
    public abstract Action getAggregatedProjectAction(MavenModuleSet var1);

    public FilePath getTarget() {
        return this.target;
    }

    protected static class MavenJavadocAction
    extends JavadocArchiver.JavadocAction {
        private final AbstractItem abstractItem;
        private final FilePath target;
        private final String title;
        private final String urlName;
        private final String displayName;

        public MavenJavadocAction(AbstractItem project, FilePath target, String title, String urlName, String displayName) {
            super(project);
            this.abstractItem = project;
            this.target = target;
            this.title = title;
            this.urlName = urlName;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            File dir = this.dir();
            if (dir != null && new File(dir, "help-doc.html").exists()) {
                return this.displayName;
            }
            return hudson.tasks.Messages.JavadocArchiver_DisplayName_Generic();
        }

        protected String getTitle() {
            return this.abstractItem.getDisplayName() + " " + this.title;
        }

        public String getUrlName() {
            return this.urlName;
        }

        protected File dir() {
            return this.target == null ? null : new File(this.target.getRemote());
        }
    }
}

