/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenUtil;
import hudson.maven.RedeployPublisher;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.maven.reporters.MavenAggregatedArtifactRecord;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.Messages;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactRecord
extends MavenAbstractArtifactRecord<MavenBuild>
implements AggregatableAction {
    public final MavenBuild parent;
    public final MavenArtifact pomArtifact;
    public final MavenArtifact mainArtifact;
    public final List<MavenArtifact> attachedArtifacts;

    public MavenArtifactRecord(MavenBuild parent, MavenArtifact pomArtifact, MavenArtifact mainArtifact, List<MavenArtifact> attachedArtifacts) {
        assert (parent != null);
        assert (pomArtifact != null);
        assert (attachedArtifacts != null);
        if (mainArtifact == null) {
            mainArtifact = pomArtifact;
        }
        this.parent = parent;
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.attachedArtifacts = attachedArtifacts;
    }

    @Override
    public MavenBuild getBuild() {
        return this.parent;
    }

    public boolean isPOM() {
        return this.mainArtifact.isPOM();
    }

    @Override
    public MavenAggregatedReport createAggregatedAction(MavenModuleSetBuild build, Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        return new MavenAggregatedArtifactRecord(build);
    }

    @Override
    public void deploy(MavenEmbedder embedder, ArtifactRepository deploymentRepository, TaskListener listener) throws MavenEmbedderException, IOException, ComponentLookupException, ArtifactDeploymentException {
        ArtifactHandlerManager handlerManager = (ArtifactHandlerManager)embedder.lookup(ArtifactHandlerManager.class);
        ArtifactFactory factory = (ArtifactFactory)embedder.lookup(ArtifactFactory.class);
        PrintStream logger = listener.getLogger();
        boolean maven3orLater = MavenUtil.maven3orLater(this.parent.getModuleSetBuild().getMavenVersionUsed());
        boolean uniqueVersion = true;
        if (!deploymentRepository.isUniqueVersion()) {
            if (maven3orLater) {
                logger.println("uniqueVersion == false is not anymore supported in maven 3");
            } else {
                ((RedeployPublisher.WrappedArtifactRepository)deploymentRepository).setUniqueVersion(false);
                uniqueVersion = false;
            }
        } else {
            ((RedeployPublisher.WrappedArtifactRepository)deploymentRepository).setUniqueVersion(true);
        }
        Artifact main = this.mainArtifact.toArtifact(handlerManager, factory, this.parent);
        if (!this.isPOM()) {
            main.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(main, this.pomArtifact.getFile(this.parent)));
        }
        logger.println(Messages.MavenArtifact_DeployingMainArtifact(main.getFile().getName()));
        ArtifactDeployer deployer = (ArtifactDeployer)embedder.lookup(ArtifactDeployer.class, uniqueVersion ? "default" : "maven2");
        deployer.deploy(main.getFile(), main, deploymentRepository, embedder.getLocalRepository());
        for (MavenArtifact aa : this.attachedArtifacts) {
            Artifact a = aa.toArtifact(handlerManager, factory, this.parent);
            logger.println(Messages.MavenArtifact_DeployingAttachedArtifact(a.getFile().getName()));
            deployer.deploy(a.getFile(), a, deploymentRepository, embedder.getLocalRepository());
        }
    }

    public void install(MavenEmbedder embedder) throws MavenEmbedderException, IOException, ComponentLookupException, ArtifactInstallationException {
        ArtifactHandlerManager handlerManager = (ArtifactHandlerManager)embedder.lookup(ArtifactHandlerManager.class);
        ArtifactInstaller installer = (ArtifactInstaller)embedder.lookup(ArtifactInstaller.class);
        ArtifactFactory factory = (ArtifactFactory)embedder.lookup(ArtifactFactory.class);
        Artifact main = this.mainArtifact.toArtifact(handlerManager, factory, this.parent);
        if (!this.isPOM()) {
            main.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(main, this.pomArtifact.getFile(this.parent)));
        }
        installer.install(this.mainArtifact.getFile(this.parent), main, embedder.getLocalRepository());
        for (MavenArtifact aa : this.attachedArtifacts) {
            installer.install(aa.getFile(this.parent), aa.toArtifact(handlerManager, factory, this.parent), embedder.getLocalRepository());
        }
    }

    public void recordFingerprints() throws IOException {
        if (this.mainArtifact != null) {
            this.mainArtifact.recordFingerprint(this.parent);
        }
        for (MavenArtifact a : this.attachedArtifacts) {
            a.recordFingerprint(this.parent);
        }
    }
}

