/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSiteArchiver
extends MavenReporter {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File destDir;
        if (!mojo.is("org.apache.maven.plugins", "maven-site-plugin", "site")) {
            return true;
        }
        try {
            destDir = mojo.getConfigurationValue("outputDirectory", File.class);
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError("Unable to find the site output directory"));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (destDir.exists()) {
            String moduleName = this.getModuleName(build, pom);
            FilePath target = build.getModuleSetRootDir().child("site").child(moduleName);
            try {
                listener.getLogger().printf("[JENKINS] Archiving site from %s to %s\n", destDir, target);
                new FilePath(destDir).copyRecursiveTo("**/*", target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy site from %s to %s", new Object[]{destDir, target}));
                build.setResult(Result.FAILURE);
            }
            build.registerAsAggregatedProjectAction(this);
        }
        return true;
    }

    private String getModuleName(MavenBuildProxy build, MavenProject pom) throws IOException {
        String moduleRoot;
        try {
            moduleRoot = build.execute(new MavenBuildProxy.BuildCallable<String, IOException>(){

                @Override
                public String call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                    return mavenBuild.getParentBuild().getModuleRoot().getRemote();
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        File pomBaseDir = pom.getBasedir();
        File remoteWorkspaceDir = new File(moduleRoot);
        if (pomBaseDir.equals(remoteWorkspaceDir)) {
            return "";
        }
        return pom.getArtifactId();
    }

    @Override
    public Collection<? extends Action> getProjectActions(MavenModule project) {
        return Collections.singleton(new SiteAction((AbstractItem)project));
    }

    @Override
    public Action getAggregatedProjectAction(MavenModuleSet project) {
        return new SiteAction((AbstractItem)project);
    }

    private static File getSiteDir(AbstractItem project) {
        return new File(project.getRootDir(), "site");
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return "Maven site";
        }

        public MavenSiteArchiver newAutoInstance(MavenModule module) {
            return new MavenSiteArchiver();
        }
    }

    public static class SiteAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public SiteAction(AbstractItem project) {
            this.project = project;
        }

        public String getUrlName() {
            return "site";
        }

        public String getDisplayName() {
            return Messages.MavenSiteArchiver_DisplayName();
        }

        public String getIconFileName() {
            if (MavenSiteArchiver.getSiteDir(this.project).exists()) {
                return "help.gif";
            }
            return null;
        }

        public DirectoryBrowserSupport doDynamic() {
            return new DirectoryBrowserSupport((ModelObject)this, new FilePath(MavenSiteArchiver.getSiteDir(this.project)), this.project.getDisplayName() + " site", "help.gif", false);
        }
    }
}

